@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowCookies If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
 * @property enableXray If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
 * @property excludedPages A list of URLs in your website or application to exclude from RUM data collection.
 * @property favoritePages A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
 * @property guestRoleArn The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
 * @property identityPoolId The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
 * @property includedPages If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
 * @property sessionSampleRate Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
 * @property telemetries An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
 */
public data class AppMonitorAppMonitorConfiguration(
    public val allowCookies: Boolean? = null,
    public val enableXray: Boolean? = null,
    public val excludedPages: List<String>? = null,
    public val favoritePages: List<String>? = null,
    public val guestRoleArn: String? = null,
    public val identityPoolId: String? = null,
    public val includedPages: List<String>? = null,
    public val sessionSampleRate: Double? = null,
    public val telemetries: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rum.outputs.AppMonitorAppMonitorConfiguration): AppMonitorAppMonitorConfiguration = AppMonitorAppMonitorConfiguration(
            allowCookies = javaType.allowCookies().map({ args0 -> args0 }).orElse(null),
            enableXray = javaType.enableXray().map({ args0 -> args0 }).orElse(null),
            excludedPages = javaType.excludedPages().map({ args0 -> args0 }),
            favoritePages = javaType.favoritePages().map({ args0 -> args0 }),
            guestRoleArn = javaType.guestRoleArn().map({ args0 -> args0 }).orElse(null),
            identityPoolId = javaType.identityPoolId().map({ args0 -> args0 }).orElse(null),
            includedPages = javaType.includedPages().map({ args0 -> args0 }),
            sessionSampleRate = javaType.sessionSampleRate().map({ args0 -> args0 }).orElse(null),
            telemetries = javaType.telemetries().map({ args0 -> args0 }),
        )
    }
}
