@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.AccessPointPublicAccessBlockConfiguration
import com.pulumi.aws.s3.kotlin.outputs.AccessPointVpcConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.s3.kotlin.outputs.AccessPointPublicAccessBlockConfiguration.Companion.toKotlin as accessPointPublicAccessBlockConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.AccessPointVpcConfiguration.Companion.toKotlin as accessPointVpcConfigurationToKotlin

/**
 * Builder for [AccessPoint].
 */
@PulumiTagMarker
public class AccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPointArgs = AccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPointArgsBuilder.() -> Unit) {
        val builder = AccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPoint {
        val builtJavaResource = com.pulumi.aws.s3.AccessPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPoint(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Point.
 * > **NOTE on Access Points and Access Point Policies:** This provider provides both a standalone Access Point Policy resource and an Access Point resource with a resource policy defined in-line. You cannot use an Access Point with in-line resource policy in conjunction with an Access Point Policy resource. Doing so will cause a conflict of policies and will overwrite the access point's resource policy.
 * > Advanced usage: To use a custom API endpoint for this resource, use the `s3control` endpoint provider configuration), not the `s3` endpoint provider configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### AWS Partition General Purpose Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.id,
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.id,
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.id())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### S3 on Outposts Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.Bucket("example", {bucket: "example"});
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.arn,
 *     name: "example",
 *     vpcConfiguration: {
 *         vpcId: exampleVpc.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.Bucket("example", bucket="example")
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.arn,
 *     name="example",
 *     vpc_configuration={
 *         "vpc_id": example_vpc.id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.Bucket("example", new()
 *     {
 *         BucketName = "example",
 *     });
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Arn,
 *         Name = "example",
 *         VpcConfiguration = new Aws.S3.Inputs.AccessPointVpcConfigurationArgs
 *         {
 *             VpcId = exampleVpc.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewBucket(ctx, "example", &s3control.BucketArgs{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.Arn,
 * 			Name:   pulumi.String("example"),
 * 			VpcConfiguration: &s3.AccessPointVpcConfigurationArgs{
 * 				VpcId: exampleVpc.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.Bucket;
 * import com.pulumi.aws.s3control.BucketArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Bucket("example", BucketArgs.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.arn())
 *             .name("example")
 *             .vpcConfiguration(AccessPointVpcConfigurationArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:Bucket
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.arn}
 *       name: example
 *       vpcConfiguration:
 *         vpcId: ${exampleVpc.id}
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * __Using `pulumi import` to import.__ For example:
 * Import using the `account_id` and `name` separated by a colon (`:`) for Access Points associated with an AWS Partition S3 Bucket:
 * ```sh
 * $ pulumi import aws:s3/accessPoint:AccessPoint example 123456789012:example
 * ```
 * Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * ```sh
 * $ pulumi import aws:s3/accessPoint:AccessPoint example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-1234567890123456/accesspoint/example
 * ```
 */
public class AccessPoint internal constructor(
    override val javaResource: com.pulumi.aws.s3.AccessPoint,
) : KotlinCustomResource(javaResource, AccessPointMapper) {
    /**
     * AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Alias of the S3 Access Point.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * ARN of the S3 Access Point.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * AWS account ID associated with the S3 bucket associated with this access point.
     */
    public val bucketAccountId: Output<String>
        get() = javaResource.bucketAccountId().applyValue({ args0 -> args0 })

    /**
     * DNS domain name of the S3 Access Point in the format _`name`_-_`account_id`_.s3-accesspoint._region_.amazonaws.com.
     * Note: S3 access points only support secure access by HTTPS. HTTP isn't supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * VPC endpoints for the S3 Access Point.
     */
    public val endpoints: Output<Map<String, String>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Indicates whether this access point currently has a policy that allows public access.
     */
    public val hasPublicAccessPolicy: Output<Boolean>
        get() = javaResource.hasPublicAccessPolicy().applyValue({ args0 -> args0 })

    /**
     * Name you want to assign to this access point. See the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html?icmpid=docs_amazons3_console#access-points-names) for naming conditions.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this access point allows access from the public Internet. Values are `VPC` (the access point doesn't allow access from the public Internet) and `Internet` (the access point allows access from the public Internet, subject to the access point and bucket access policies).
     */
    public val networkOrigin: Output<String>
        get() = javaResource.networkOrigin().applyValue({ args0 -> args0 })

    /**
     * Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    public val publicAccessBlockConfiguration: Output<AccessPointPublicAccessBlockConfiguration>?
        get() = javaResource.publicAccessBlockConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessPointPublicAccessBlockConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    public val vpcConfiguration: Output<AccessPointVpcConfiguration>?
        get() = javaResource.vpcConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> accessPointVpcConfigurationToKotlin(args0) })
            }).orElse(null)
        })
}

public object AccessPointMapper : ResourceMapper<AccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.AccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): AccessPoint = AccessPoint(
        javaResource as
            com.pulumi.aws.s3.AccessPoint,
    )
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPoint].
 */
public suspend fun accessPoint(name: String, block: suspend AccessPointResourceBuilder.() -> Unit): AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPoint(name: String): AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
