@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.AccessPointArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.AccessPointPublicAccessBlockConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.AccessPointPublicAccessBlockConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.AccessPointVpcConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.AccessPointVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Point.
 * > **NOTE on Access Points and Access Point Policies:** This provider provides both a standalone Access Point Policy resource and an Access Point resource with a resource policy defined in-line. You cannot use an Access Point with in-line resource policy in conjunction with an Access Point Policy resource. Doing so will cause a conflict of policies and will overwrite the access point's resource policy.
 * > Advanced usage: To use a custom API endpoint for this resource, use the `s3control` endpoint provider configuration), not the `s3` endpoint provider configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### AWS Partition General Purpose Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.id,
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.id,
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.id())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### S3 on Outposts Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.Bucket("example", {bucket: "example"});
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.arn,
 *     name: "example",
 *     vpcConfiguration: {
 *         vpcId: exampleVpc.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.Bucket("example", bucket="example")
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.arn,
 *     name="example",
 *     vpc_configuration={
 *         "vpc_id": example_vpc.id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.Bucket("example", new()
 *     {
 *         BucketName = "example",
 *     });
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Arn,
 *         Name = "example",
 *         VpcConfiguration = new Aws.S3.Inputs.AccessPointVpcConfigurationArgs
 *         {
 *             VpcId = exampleVpc.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewBucket(ctx, "example", &s3control.BucketArgs{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.Arn,
 * 			Name:   pulumi.String("example"),
 * 			VpcConfiguration: &s3.AccessPointVpcConfigurationArgs{
 * 				VpcId: exampleVpc.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.Bucket;
 * import com.pulumi.aws.s3control.BucketArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Bucket("example", BucketArgs.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.arn())
 *             .name("example")
 *             .vpcConfiguration(AccessPointVpcConfigurationArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:Bucket
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.arn}
 *       name: example
 *       vpcConfiguration:
 *         vpcId: ${exampleVpc.id}
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * __Using `pulumi import` to import.__ For example:
 * Import using the `account_id` and `name` separated by a colon (`:`) for Access Points associated with an AWS Partition S3 Bucket:
 * ```sh
 * $ pulumi import aws:s3/accessPoint:AccessPoint example 123456789012:example
 * ```
 * Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * ```sh
 * $ pulumi import aws:s3/accessPoint:AccessPoint example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-1234567890123456/accesspoint/example
 * ```
 * @property accountId AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
 * @property bucket Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
 * @property bucketAccountId AWS account ID associated with the S3 bucket associated with this access point.
 * @property name Name you want to assign to this access point. See the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html?icmpid=docs_amazons3_console#access-points-names) for naming conditions.
 * The following arguments are optional:
 * @property policy Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
 * @property publicAccessBlockConfiguration Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
 * @property vpcConfiguration Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
 */
public data class AccessPointArgs(
    public val accountId: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val bucketAccountId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val publicAccessBlockConfiguration: Output<AccessPointPublicAccessBlockConfigurationArgs>? =
        null,
    public val vpcConfiguration: Output<AccessPointVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.AccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3.AccessPointArgs =
        com.pulumi.aws.s3.AccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .bucketAccountId(bucketAccountId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .publicAccessBlockConfiguration(
                publicAccessBlockConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessPointArgs].
 */
@PulumiTagMarker
public class AccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var bucket: Output<String>? = null

    private var bucketAccountId: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var publicAccessBlockConfiguration: Output<AccessPointPublicAccessBlockConfigurationArgs>? =
        null

    private var vpcConfiguration: Output<AccessPointVpcConfigurationArgs>? = null

    /**
     * @param value AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("jlgjjutqewhifsxn")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
     */
    @JvmName("qwovsesnkchqtsae")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value AWS account ID associated with the S3 bucket associated with this access point.
     */
    @JvmName("lckolxhsircfhihq")
    public suspend fun bucketAccountId(`value`: Output<String>) {
        this.bucketAccountId = value
    }

    /**
     * @param value Name you want to assign to this access point. See the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html?icmpid=docs_amazons3_console#access-points-names) for naming conditions.
     * The following arguments are optional:
     */
    @JvmName("dbhfwmirrneooshg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("uekuuorpntcueetn")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("akwbbrjlemoigadr")
    public suspend fun publicAccessBlockConfiguration(`value`: Output<AccessPointPublicAccessBlockConfigurationArgs>) {
        this.publicAccessBlockConfiguration = value
    }

    /**
     * @param value Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("idmbmqehcxyepnrx")
    public suspend fun vpcConfiguration(`value`: Output<AccessPointVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("vevprwfqukvumcit")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
     */
    @JvmName("julycfnuaeqflfro")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value AWS account ID associated with the S3 bucket associated with this access point.
     */
    @JvmName("dgthvyryjfmkrdee")
    public suspend fun bucketAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketAccountId = mapped
    }

    /**
     * @param value Name you want to assign to this access point. See the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html?icmpid=docs_amazons3_console#access-points-names) for naming conditions.
     * The following arguments are optional:
     */
    @JvmName("fmpibyktcfrcquvy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("ikpbwwhdluiwnxye")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("klngrdxfnpskjryf")
    public suspend fun publicAccessBlockConfiguration(`value`: AccessPointPublicAccessBlockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccessBlockConfiguration = mapped
    }

    /**
     * @param argument Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("shpvsikvrlfsprak")
    public suspend fun publicAccessBlockConfiguration(argument: suspend AccessPointPublicAccessBlockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointPublicAccessBlockConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicAccessBlockConfiguration = mapped
    }

    /**
     * @param value Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("ekgiwsfbmnfdsckx")
    public suspend fun vpcConfiguration(`value`: AccessPointVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("naggdvohjdxoddcd")
    public suspend fun vpcConfiguration(argument: suspend AccessPointVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointVpcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): AccessPointArgs = AccessPointArgs(
        accountId = accountId,
        bucket = bucket,
        bucketAccountId = bucketAccountId,
        name = name,
        policy = policy,
        publicAccessBlockConfiguration = publicAccessBlockConfiguration,
        vpcConfiguration = vpcConfiguration,
    )
}
