@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountPublicAccessBlock].
 */
@PulumiTagMarker
public class AccountPublicAccessBlockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountPublicAccessBlockArgs = AccountPublicAccessBlockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountPublicAccessBlockArgsBuilder.() -> Unit) {
        val builder = AccountPublicAccessBlockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountPublicAccessBlock {
        val builtJavaResource = com.pulumi.aws.s3.AccountPublicAccessBlock(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountPublicAccessBlock(builtJavaResource)
    }
}

/**
 * Manages S3 account-level Public Access Block configuration. For more information about these settings, see the [AWS S3 Block Public Access documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 * > **NOTE:** Each AWS account may only have one S3 Public Access Block configuration. Multiple configurations of the resource against the same AWS account will cause a perpetual difference.
 * > Advanced usage: To use a custom API endpoint for this resource, use the `s3control` endpoint provider configuration, not the `s3` endpoint provider configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.AccountPublicAccessBlock("example", {
 *     blockPublicAcls: true,
 *     blockPublicPolicy: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.AccountPublicAccessBlock("example",
 *     block_public_acls=True,
 *     block_public_policy=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.AccountPublicAccessBlock("example", new()
 *     {
 *         BlockPublicAcls = true,
 *         BlockPublicPolicy = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewAccountPublicAccessBlock(ctx, "example", &s3.AccountPublicAccessBlockArgs{
 * 			BlockPublicAcls:   pulumi.Bool(true),
 * 			BlockPublicPolicy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.AccountPublicAccessBlock;
 * import com.pulumi.aws.s3.AccountPublicAccessBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountPublicAccessBlock("example", AccountPublicAccessBlockArgs.builder()
 *             .blockPublicAcls(true)
 *             .blockPublicPolicy(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:AccountPublicAccessBlock
 *     properties:
 *       blockPublicAcls: true
 *       blockPublicPolicy: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_s3_account_public_access_block` using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:s3/accountPublicAccessBlock:AccountPublicAccessBlock example 123456789012
 * ```
 */
public class AccountPublicAccessBlock internal constructor(
    override val javaResource: com.pulumi.aws.s3.AccountPublicAccessBlock,
) : KotlinCustomResource(javaResource, AccountPublicAccessBlockMapper) {
    /**
     * AWS account ID to configure. Defaults to automatically determined account ID of the this provider AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls fail if the request includes a public ACL.
     */
    public val blockPublicAcls: Output<Boolean>?
        get() = javaResource.blockPublicAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    public val blockPublicPolicy: Output<Boolean>?
        get() = javaResource.blockPublicPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore all public ACLs on buckets in this account and any objects that they contain.
     */
    public val ignorePublicAcls: Output<Boolean>?
        get() = javaResource.ignorePublicAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access buckets with public policies.
     */
    public val restrictPublicBuckets: Output<Boolean>?
        get() = javaResource.restrictPublicBuckets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AccountPublicAccessBlockMapper : ResourceMapper<AccountPublicAccessBlock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.AccountPublicAccessBlock::class == javaResource::class

    override fun map(javaResource: Resource): AccountPublicAccessBlock =
        AccountPublicAccessBlock(javaResource as com.pulumi.aws.s3.AccountPublicAccessBlock)
}

/**
 * @see [AccountPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountPublicAccessBlock].
 */
public suspend fun accountPublicAccessBlock(
    name: String,
    block: suspend AccountPublicAccessBlockResourceBuilder.() -> Unit,
): AccountPublicAccessBlock {
    val builder = AccountPublicAccessBlockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountPublicAccessBlock(name: String): AccountPublicAccessBlock {
    val builder = AccountPublicAccessBlockResourceBuilder()
    builder.name(name)
    return builder.build()
}
