@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.AnalyticsConfigurationArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationFilterArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationStorageClassAnalysisArgs
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationStorageClassAnalysisArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket [analytics configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add analytics configuration for entire S3 bucket and export results to a second S3 bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const analytics = new aws.s3.BucketV2("analytics", {bucket: "analytics destination"});
 * const example_entire_bucket = new aws.s3.AnalyticsConfiguration("example-entire-bucket", {
 *     bucket: example.id,
 *     name: "EntireBucket",
 *     storageClassAnalysis: {
 *         dataExport: {
 *             destination: {
 *                 s3BucketDestination: {
 *                     bucketArn: analytics.arn,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * analytics = aws.s3.BucketV2("analytics", bucket="analytics destination")
 * example_entire_bucket = aws.s3.AnalyticsConfiguration("example-entire-bucket",
 *     bucket=example.id,
 *     name="EntireBucket",
 *     storage_class_analysis={
 *         "data_export": {
 *             "destination": {
 *                 "s3_bucket_destination": {
 *                     "bucket_arn": analytics.arn,
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var analytics = new Aws.S3.BucketV2("analytics", new()
 *     {
 *         Bucket = "analytics destination",
 *     });
 *     var example_entire_bucket = new Aws.S3.AnalyticsConfiguration("example-entire-bucket", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "EntireBucket",
 *         StorageClassAnalysis = new Aws.S3.Inputs.AnalyticsConfigurationStorageClassAnalysisArgs
 *         {
 *             DataExport = new Aws.S3.Inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs
 *             {
 *                 Destination = new Aws.S3.Inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs
 *                 {
 *                     S3BucketDestination = new Aws.S3.Inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs
 *                     {
 *                         BucketArn = analytics.Arn,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		analytics, err := s3.NewBucketV2(ctx, "analytics", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("analytics destination"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAnalyticsConfiguration(ctx, "example-entire-bucket", &s3.AnalyticsConfigurationArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("EntireBucket"),
 * 			StorageClassAnalysis: &s3.AnalyticsConfigurationStorageClassAnalysisArgs{
 * 				DataExport: &s3.AnalyticsConfigurationStorageClassAnalysisDataExportArgs{
 * 					Destination: &s3.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs{
 * 						S3BucketDestination: &s3.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs{
 * 							BucketArn: analytics.Arn,
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var analytics = new BucketV2("analytics", BucketV2Args.builder()
 *             .bucket("analytics destination")
 *             .build());
 *         var example_entire_bucket = new AnalyticsConfiguration("example-entire-bucket", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .name("EntireBucket")
 *             .storageClassAnalysis(AnalyticsConfigurationStorageClassAnalysisArgs.builder()
 *                 .dataExport(AnalyticsConfigurationStorageClassAnalysisDataExportArgs.builder()
 *                     .destination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs.builder()
 *                         .s3BucketDestination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs.builder()
 *                             .bucketArn(analytics.arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example-entire-bucket:
 *     type: aws:s3:AnalyticsConfiguration
 *     properties:
 *       bucket: ${example.id}
 *       name: EntireBucket
 *       storageClassAnalysis:
 *         dataExport:
 *           destination:
 *             s3BucketDestination:
 *               bucketArn: ${analytics.arn}
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   analytics:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: analytics destination
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Add analytics configuration with S3 object filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const example_filtered = new aws.s3.AnalyticsConfiguration("example-filtered", {
 *     bucket: example.id,
 *     name: "ImportantBlueDocuments",
 *     filter: {
 *         prefix: "documents/",
 *         tags: {
 *             priority: "high",
 *             "class": "blue",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_filtered = aws.s3.AnalyticsConfiguration("example-filtered",
 *     bucket=example.id,
 *     name="ImportantBlueDocuments",
 *     filter={
 *         "prefix": "documents/",
 *         "tags": {
 *             "priority": "high",
 *             "class_": "blue",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var example_filtered = new Aws.S3.AnalyticsConfiguration("example-filtered", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "ImportantBlueDocuments",
 *         Filter = new Aws.S3.Inputs.AnalyticsConfigurationFilterArgs
 *         {
 *             Prefix = "documents/",
 *             Tags =
 *             {
 *                 { "priority", "high" },
 *                 { "class", "blue" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewAnalyticsConfiguration(ctx, "example-filtered", &s3.AnalyticsConfigurationArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("ImportantBlueDocuments"),
 * 			Filter: &s3.AnalyticsConfigurationFilterArgs{
 * 				Prefix: pulumi.String("documents/"),
 * 				Tags: pulumi.StringMap{
 * 					"priority": pulumi.String("high"),
 * 					"class":    pulumi.String("blue"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var example_filtered = new AnalyticsConfiguration("example-filtered", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .name("ImportantBlueDocuments")
 *             .filter(AnalyticsConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example-filtered:
 *     type: aws:s3:AnalyticsConfiguration
 *     properties:
 *       bucket: ${example.id}
 *       name: ImportantBlueDocuments
 *       filter:
 *         prefix: documents/
 *         tags:
 *           priority: high
 *           class: blue
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket analytics configurations using `bucket:analytics`. For example:
 * ```sh
 * $ pulumi import aws:s3/analyticsConfiguration:AnalyticsConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the bucket this analytics configuration is associated with.
 * @property filter Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
 * @property name Unique identifier of the analytics configuration for the bucket.
 * @property storageClassAnalysis Configuration for the analytics data export (documented below).
 */
public data class AnalyticsConfigurationArgs(
    public val bucket: Output<String>? = null,
    public val filter: Output<AnalyticsConfigurationFilterArgs>? = null,
    public val name: Output<String>? = null,
    public val storageClassAnalysis: Output<AnalyticsConfigurationStorageClassAnalysisArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.AnalyticsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.AnalyticsConfigurationArgs =
        com.pulumi.aws.s3.AnalyticsConfigurationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageClassAnalysis(
                storageClassAnalysis?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalyticsConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var filter: Output<AnalyticsConfigurationFilterArgs>? = null

    private var name: Output<String>? = null

    private var storageClassAnalysis: Output<AnalyticsConfigurationStorageClassAnalysisArgs>? = null

    /**
     * @param value Name of the bucket this analytics configuration is associated with.
     */
    @JvmName("rjmgxavmagjyalad")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("hrelcxkwmciabene")
    public suspend fun filter(`value`: Output<AnalyticsConfigurationFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier of the analytics configuration for the bucket.
     */
    @JvmName("umsdwhyqefbbuayc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for the analytics data export (documented below).
     */
    @JvmName("ragijvsgxwbxgjnx")
    public suspend fun storageClassAnalysis(`value`: Output<AnalyticsConfigurationStorageClassAnalysisArgs>) {
        this.storageClassAnalysis = value
    }

    /**
     * @param value Name of the bucket this analytics configuration is associated with.
     */
    @JvmName("tgxbatkjyubrwofg")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("uafojefvxjvbqkgs")
    public suspend fun filter(`value`: AnalyticsConfigurationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("srhhlivasyduuicw")
    public suspend fun filter(argument: suspend AnalyticsConfigurationFilterArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConfigurationFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier of the analytics configuration for the bucket.
     */
    @JvmName("hvherwrskwtnuari")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for the analytics data export (documented below).
     */
    @JvmName("nkprbyhntifveswn")
    public suspend fun storageClassAnalysis(`value`: AnalyticsConfigurationStorageClassAnalysisArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassAnalysis = mapped
    }

    /**
     * @param argument Configuration for the analytics data export (documented below).
     */
    @JvmName("sduajyiihtjxyxie")
    public suspend fun storageClassAnalysis(argument: suspend AnalyticsConfigurationStorageClassAnalysisArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConfigurationStorageClassAnalysisArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageClassAnalysis = mapped
    }

    internal fun build(): AnalyticsConfigurationArgs = AnalyticsConfigurationArgs(
        bucket = bucket,
        filter = filter,
        name = name,
        storageClassAnalysis = storageClassAnalysis,
    )
}
