@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAccelerateConfigurationV2].
 */
@PulumiTagMarker
public class BucketAccelerateConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAccelerateConfigurationV2Args = BucketAccelerateConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAccelerateConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketAccelerateConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketAccelerateConfigurationV2 {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketAccelerateConfigurationV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketAccelerateConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket accelerate configuration resource. See the [Requirements for using Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transfer-acceleration.html#transfer-acceleration-requirements) for more details.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mybucket = new aws.s3.BucketV2("mybucket", {bucket: "mybucket"});
 * const example = new aws.s3.BucketAccelerateConfigurationV2("example", {
 *     bucket: mybucket.id,
 *     status: "Enabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mybucket = aws.s3.BucketV2("mybucket", bucket="mybucket")
 * example = aws.s3.BucketAccelerateConfigurationV2("example",
 *     bucket=mybucket.id,
 *     status="Enabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mybucket = new Aws.S3.BucketV2("mybucket", new()
 *     {
 *         Bucket = "mybucket",
 *     });
 *     var example = new Aws.S3.BucketAccelerateConfigurationV2("example", new()
 *     {
 *         Bucket = mybucket.Id,
 *         Status = "Enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mybucket, err := s3.NewBucketV2(ctx, "mybucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("mybucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAccelerateConfigurationV2(ctx, "example", &s3.BucketAccelerateConfigurationV2Args{
 * 			Bucket: mybucket.ID(),
 * 			Status: pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mybucket = new BucketV2("mybucket", BucketV2Args.builder()
 *             .bucket("mybucket")
 *             .build());
 *         var example = new BucketAccelerateConfigurationV2("example", BucketAccelerateConfigurationV2Args.builder()
 *             .bucket(mybucket.id())
 *             .status("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   mybucket:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: mybucket
 *   example:
 *     type: aws:s3:BucketAccelerateConfigurationV2
 *     properties:
 *       bucket: ${mybucket.id}
 *       status: Enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import.__ For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name,123456789012
 * ```
 */
public class BucketAccelerateConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketAccelerateConfigurationV2,
) : KotlinCustomResource(javaResource, BucketAccelerateConfigurationV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BucketAccelerateConfigurationV2Mapper :
    ResourceMapper<BucketAccelerateConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketAccelerateConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketAccelerateConfigurationV2 =
        BucketAccelerateConfigurationV2(
            javaResource as
                com.pulumi.aws.s3.BucketAccelerateConfigurationV2,
        )
}

/**
 * @see [BucketAccelerateConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAccelerateConfigurationV2].
 */
public suspend fun bucketAccelerateConfigurationV2(
    name: String,
    block: suspend BucketAccelerateConfigurationV2ResourceBuilder.() -> Unit,
): BucketAccelerateConfigurationV2 {
    val builder = BucketAccelerateConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAccelerateConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAccelerateConfigurationV2(name: String): BucketAccelerateConfigurationV2 {
    val builder = BucketAccelerateConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
