@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket accelerate configuration resource. See the [Requirements for using Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transfer-acceleration.html#transfer-acceleration-requirements) for more details.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mybucket = new aws.s3.BucketV2("mybucket", {bucket: "mybucket"});
 * const example = new aws.s3.BucketAccelerateConfigurationV2("example", {
 *     bucket: mybucket.id,
 *     status: "Enabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mybucket = aws.s3.BucketV2("mybucket", bucket="mybucket")
 * example = aws.s3.BucketAccelerateConfigurationV2("example",
 *     bucket=mybucket.id,
 *     status="Enabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mybucket = new Aws.S3.BucketV2("mybucket", new()
 *     {
 *         Bucket = "mybucket",
 *     });
 *     var example = new Aws.S3.BucketAccelerateConfigurationV2("example", new()
 *     {
 *         Bucket = mybucket.Id,
 *         Status = "Enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mybucket, err := s3.NewBucketV2(ctx, "mybucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("mybucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAccelerateConfigurationV2(ctx, "example", &s3.BucketAccelerateConfigurationV2Args{
 * 			Bucket: mybucket.ID(),
 * 			Status: pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mybucket = new BucketV2("mybucket", BucketV2Args.builder()
 *             .bucket("mybucket")
 *             .build());
 *         var example = new BucketAccelerateConfigurationV2("example", BucketAccelerateConfigurationV2Args.builder()
 *             .bucket(mybucket.id())
 *             .status("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   mybucket:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: mybucket
 *   example:
 *     type: aws:s3:BucketAccelerateConfigurationV2
 *     properties:
 *       bucket: ${mybucket.id}
 *       status: Enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import.__ For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property status Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
 */
public data class BucketAccelerateConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args =
        com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccelerateConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketAccelerateConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("xpysolwtocxnlsry")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("xpqukqokkblpkewi")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
     */
    @JvmName("gukfclabdssjuhjb")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("tjghprlxibcfhulc")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("cbxojqftpmflkqvl")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
     */
    @JvmName("nckcukwdaosvkmew")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketAccelerateConfigurationV2Args = BucketAccelerateConfigurationV2Args(
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
        status = status,
    )
}
