@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketArgs.builder
import com.pulumi.aws.s3.kotlin.enums.CannedAcl
import com.pulumi.aws.s3.kotlin.inputs.BucketCorsRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketCorsRuleArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketGrantArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketGrantArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketLifecycleRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketLifecycleRuleArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketObjectLockConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketObjectLockConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketReplicationConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketReplicationConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketServerSideEncryptionConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketVersioningArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketVersioningArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket resource.
 * > This resource provides functionality for managing S3 general purpose buckets in an AWS Partition. To manage Amazon S3 Express directory buckets, use the `aws_directory_bucket` resource. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), use the `aws.s3control.Bucket` resource.
 * > Object Lock can be enabled by using the `object_lock_enable` attribute or by using the `aws.s3.BucketObjectLockConfigurationV2` resource. Please note, that by using the resource, Object Lock can be enabled/disabled without destroying and recreating the bucket.
 * ## Example Usage
 * ### Private Bucket With Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucket: "my-tf-test-bucket",
 *     tags: {
 *         Name: "My bucket",
 *         Environment: "Dev",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket="my-tf-test-bucket",
 *     tags={
 *         "Name": "My bucket",
 *         "Environment": "Dev",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-tf-test-bucket",
 *         Tags =
 *         {
 *             { "Name", "My bucket" },
 *             { "Environment", "Dev" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-test-bucket"),
 * 			Tags: pulumi.StringMap{
 * 				"Name":        pulumi.String("My bucket"),
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("my-tf-test-bucket")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "My bucket"),
 *                 Map.entry("Environment", "Dev")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-test-bucket
 *       tags:
 *         Name: My bucket
 *         Environment: Dev
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket using the `bucket`. For example:
 * ```sh
 * $ pulumi import aws:s3/bucket:Bucket bucket bucket-name
 * ```
 * @property accelerationStatus Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
 * @property acl The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
 * @property arn ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
 * @property bucket Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
 * @property bucketPrefix Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
 * @property corsRules Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
 * @property forceDestroy Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
 * @property grants An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
 * @property hostedZoneId [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
 * @property lifecycleRules Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
 * @property loggings Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketLoggingV2` instead.
 * @property objectLockConfiguration Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
 * The provider wil only perform drift detection if a configuration value is provided.
 * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
 * @property policy Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketPolicy` instead.
 * @property replicationConfiguration Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketReplicationConfig` instead.
 * @property requestPayer Specifies who should bear the cost of Amazon S3 data transfer.
 * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
 * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
 * @property serverSideEncryptionConfiguration Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
 * @property tags Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following arguments are deprecated, and will be removed in a future major version:
 * @property versioning Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
 * @property website Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
 * @property websiteDomain (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
 * @property websiteEndpoint (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
 */
public data class BucketArgs(
    public val accelerationStatus: Output<String>? = null,
    public val acl: Output<Either<String, CannedAcl>>? = null,
    public val arn: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val bucketPrefix: Output<String>? = null,
    public val corsRules: Output<List<BucketCorsRuleArgs>>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val grants: Output<List<BucketGrantArgs>>? = null,
    public val hostedZoneId: Output<String>? = null,
    public val lifecycleRules: Output<List<BucketLifecycleRuleArgs>>? = null,
    public val loggings: Output<List<BucketLoggingArgs>>? = null,
    public val objectLockConfiguration: Output<BucketObjectLockConfigurationArgs>? = null,
    public val policy: Output<String>? = null,
    public val replicationConfiguration: Output<BucketReplicationConfigurationArgs>? = null,
    public val requestPayer: Output<String>? = null,
    public val serverSideEncryptionConfiguration: Output<BucketServerSideEncryptionConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val versioning: Output<BucketVersioningArgs>? = null,
    public val website: Output<BucketWebsiteArgs>? = null,
    public val websiteDomain: Output<String>? = null,
    public val websiteEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketArgs = com.pulumi.aws.s3.BucketArgs.builder()
        .accelerationStatus(accelerationStatus?.applyValue({ args0 -> args0 }))
        .acl(
            acl?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .arn(arn?.applyValue({ args0 -> args0 }))
        .bucket(bucket?.applyValue({ args0 -> args0 }))
        .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
        .corsRules(
            corsRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
        .grants(grants?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .hostedZoneId(hostedZoneId?.applyValue({ args0 -> args0 }))
        .lifecycleRules(
            lifecycleRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .loggings(
            loggings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .objectLockConfiguration(
            objectLockConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .policy(policy?.applyValue({ args0 -> args0 }))
        .replicationConfiguration(
            replicationConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .requestPayer(requestPayer?.applyValue({ args0 -> args0 }))
        .serverSideEncryptionConfiguration(
            serverSideEncryptionConfiguration?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .versioning(versioning?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .website(website?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .websiteDomain(websiteDomain?.applyValue({ args0 -> args0 }))
        .websiteEndpoint(websiteEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketArgs].
 */
@PulumiTagMarker
public class BucketArgsBuilder internal constructor() {
    private var accelerationStatus: Output<String>? = null

    private var acl: Output<Either<String, CannedAcl>>? = null

    private var arn: Output<String>? = null

    private var bucket: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var corsRules: Output<List<BucketCorsRuleArgs>>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var grants: Output<List<BucketGrantArgs>>? = null

    private var hostedZoneId: Output<String>? = null

    private var lifecycleRules: Output<List<BucketLifecycleRuleArgs>>? = null

    private var loggings: Output<List<BucketLoggingArgs>>? = null

    private var objectLockConfiguration: Output<BucketObjectLockConfigurationArgs>? = null

    private var policy: Output<String>? = null

    private var replicationConfiguration: Output<BucketReplicationConfigurationArgs>? = null

    private var requestPayer: Output<String>? = null

    private var serverSideEncryptionConfiguration:
        Output<BucketServerSideEncryptionConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versioning: Output<BucketVersioningArgs>? = null

    private var website: Output<BucketWebsiteArgs>? = null

    private var websiteDomain: Output<String>? = null

    private var websiteEndpoint: Output<String>? = null

    /**
     * @param value Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     */
    @JvmName("asnjxhkwalewduom")
    public suspend fun accelerationStatus(`value`: Output<String>) {
        this.accelerationStatus = value
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("qcybeutnulexnsto")
    public suspend fun acl(`value`: Output<Either<String, CannedAcl>>) {
        this.acl = value
    }

    /**
     * @param value ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     */
    @JvmName("tfhuknapehonylok")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
     */
    @JvmName("hmowuspwopogujmt")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    @JvmName("rortuqwwyndxxjol")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("iwetvrgwbvhlxxod")
    public suspend fun corsRules(`value`: Output<List<BucketCorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("txlhfkloemuigtih")
    public suspend fun corsRules(vararg values: Output<BucketCorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("etbseipwlocsdpdm")
    public suspend fun corsRules(values: List<Output<BucketCorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("tohqsfjjmirfyevd")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("ywvedxkownqoxqwk")
    public suspend fun grants(`value`: Output<List<BucketGrantArgs>>) {
        this.grants = value
    }

    @JvmName("xpvqrgkkliecgpdb")
    public suspend fun grants(vararg values: Output<BucketGrantArgs>) {
        this.grants = Output.all(values.asList())
    }

    /**
     * @param values An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("kjihkxvymlhihjyx")
    public suspend fun grants(values: List<Output<BucketGrantArgs>>) {
        this.grants = Output.all(values)
    }

    /**
     * @param value [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
     */
    @JvmName("ljqbtqxwnvtnfifb")
    public suspend fun hostedZoneId(`value`: Output<String>) {
        this.hostedZoneId = value
    }

    /**
     * @param value Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("onlipyqkumtxvsmd")
    public suspend fun lifecycleRules(`value`: Output<List<BucketLifecycleRuleArgs>>) {
        this.lifecycleRules = value
    }

    @JvmName("cplqjpbiddihtyxu")
    public suspend fun lifecycleRules(vararg values: Output<BucketLifecycleRuleArgs>) {
        this.lifecycleRules = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("fuxlcloxdylcseos")
    public suspend fun lifecycleRules(values: List<Output<BucketLifecycleRuleArgs>>) {
        this.lifecycleRules = Output.all(values)
    }

    /**
     * @param value Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("gxopbqdivxjnfuer")
    public suspend fun loggings(`value`: Output<List<BucketLoggingArgs>>) {
        this.loggings = value
    }

    @JvmName("sdwnhenjltevtjns")
    public suspend fun loggings(vararg values: Output<BucketLoggingArgs>) {
        this.loggings = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("tifurgtmxqfycwqf")
    public suspend fun loggings(values: List<Output<BucketLoggingArgs>>) {
        this.loggings = Output.all(values)
    }

    /**
     * @param value Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @JvmName("hryuossvbkkivkrw")
    public suspend fun objectLockConfiguration(`value`: Output<BucketObjectLockConfigurationArgs>) {
        this.objectLockConfiguration = value
    }

    /**
     * @param value Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     */
    @JvmName("ocnmetcumjbfpsft")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @JvmName("pklfwunywmimsfjc")
    public suspend fun replicationConfiguration(`value`: Output<BucketReplicationConfigurationArgs>) {
        this.replicationConfiguration = value
    }

    /**
     * @param value Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     */
    @JvmName("shbahvitdjfxquyv")
    public suspend fun requestPayer(`value`: Output<String>) {
        this.requestPayer = value
    }

    /**
     * @param value Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @JvmName("ivahqdxgwxvkauee")
    public suspend fun serverSideEncryptionConfiguration(`value`: Output<BucketServerSideEncryptionConfigurationArgs>) {
        this.serverSideEncryptionConfiguration = value
    }

    /**
     * @param value Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("sxnelbbehfbawmos")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @JvmName("wwbnjulyrbxusykk")
    public suspend fun versioning(`value`: Output<BucketVersioningArgs>) {
        this.versioning = value
    }

    /**
     * @param value Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("apvnauqoqoiomhso")
    public suspend fun website(`value`: Output<BucketWebsiteArgs>) {
        this.website = value
    }

    /**
     * @param value (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("boacjnkrkoaiilsu")
    public suspend fun websiteDomain(`value`: Output<String>) {
        this.websiteDomain = value
    }

    /**
     * @param value (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("nhhupeegwtlsiymn")
    public suspend fun websiteEndpoint(`value`: Output<String>) {
        this.websiteEndpoint = value
    }

    /**
     * @param value Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     */
    @JvmName("vjahcjbwrenbbpvq")
    public suspend fun accelerationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerationStatus = mapped
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("cfkueatidownfvnu")
    public suspend fun acl(`value`: Either<String, CannedAcl>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("tnulsiyetexttstr")
    public fun acl(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CannedAcl>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("viwpnwqhdixmquki")
    public fun acl(`value`: CannedAcl) {
        val toBeMapped = Either.ofRight<String, CannedAcl>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     */
    @JvmName("alrwohrgalrbsqhk")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
     */
    @JvmName("yxkonrkgvkwggrpm")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    @JvmName("bwevighduveglmrx")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("tfaqenrntrtctven")
    public suspend fun corsRules(`value`: List<BucketCorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("lrotwvtfmftorlmw")
    public suspend fun corsRules(argument: List<suspend BucketCorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("lmgvoetkplrlvuvj")
    public suspend fun corsRules(vararg argument: suspend BucketCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("fsiyatsxupoumxuh")
    public suspend fun corsRules(argument: suspend BucketCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketCorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @JvmName("kyxijeqwoywaecmd")
    public suspend fun corsRules(vararg values: BucketCorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param value Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("jqoyuqxleqsmmqcn")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("ulemaoctbghlqwug")
    public suspend fun grants(`value`: List<BucketGrantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("kpbogabocwnkkrqd")
    public suspend fun grants(argument: List<suspend BucketGrantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BucketGrantArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("whyeualxsjtphqre")
    public suspend fun grants(vararg argument: suspend BucketGrantArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BucketGrantArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("fuebxfqpllcncgot")
    public suspend fun grants(argument: suspend BucketGrantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketGrantArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param values An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @JvmName("msxqfimhdvslqual")
    public suspend fun grants(vararg values: BucketGrantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param value [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
     */
    @JvmName("wysynyfcoqrrtjfe")
    public suspend fun hostedZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneId = mapped
    }

    /**
     * @param value Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("xkbmketxqpgaoanm")
    public suspend fun lifecycleRules(`value`: List<BucketLifecycleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("etxnfkhvhvhhcfca")
    public suspend fun lifecycleRules(argument: List<suspend BucketLifecycleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("brjsrlxplrppmrms")
    public suspend fun lifecycleRules(vararg argument: suspend BucketLifecycleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("nhrvnyblefeejduv")
    public suspend fun lifecycleRules(argument: suspend BucketLifecycleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketLifecycleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param values Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @JvmName("ltlqslalfglvtbis")
    public suspend fun lifecycleRules(vararg values: BucketLifecycleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param value Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("egurpdercrfsjshi")
    public suspend fun loggings(`value`: List<BucketLoggingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("toblibrpemfxqxdm")
    public suspend fun loggings(argument: List<suspend BucketLoggingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLoggingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("epkykoxpwcowdcso")
    public suspend fun loggings(vararg argument: suspend BucketLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLoggingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("ueedrxeloxtqmvnd")
    public suspend fun loggings(argument: suspend BucketLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketLoggingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param values Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @JvmName("ydxvfflsbwyrwfgx")
    public suspend fun loggings(vararg values: BucketLoggingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggings = mapped
    }

    /**
     * @param value Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @JvmName("tkfudafwjbqdddnb")
    public suspend fun objectLockConfiguration(`value`: BucketObjectLockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockConfiguration = mapped
    }

    /**
     * @param argument Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @JvmName("xblicpnakooeiyoc")
    public suspend fun objectLockConfiguration(argument: suspend BucketObjectLockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.objectLockConfiguration = mapped
    }

    /**
     * @param value Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     */
    @JvmName("aykgohjwbfwwccbo")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @JvmName("mcdndaprkvoatqaa")
    public suspend fun replicationConfiguration(`value`: BucketReplicationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationConfiguration = mapped
    }

    /**
     * @param argument Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @JvmName("ufukdggdsdxnvejr")
    public suspend fun replicationConfiguration(argument: suspend BucketReplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.replicationConfiguration = mapped
    }

    /**
     * @param value Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     */
    @JvmName("wcjduyjoccuxlysb")
    public suspend fun requestPayer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestPayer = mapped
    }

    /**
     * @param value Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @JvmName("nvjhjhnveauvipiw")
    public suspend fun serverSideEncryptionConfiguration(`value`: BucketServerSideEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @JvmName("exjkupofwqnjwhcq")
    public suspend fun serverSideEncryptionConfiguration(argument: suspend BucketServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketServerSideEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param value Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("yjbkrewdaqfdbkpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("pngxyhwrwwinbxbq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @JvmName("rhjjytrmfegufkfd")
    public suspend fun versioning(`value`: BucketVersioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioning = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @JvmName("aqoyokagmyyeumcs")
    public suspend fun versioning(argument: suspend BucketVersioningArgsBuilder.() -> Unit) {
        val toBeMapped = BucketVersioningArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.versioning = mapped
    }

    /**
     * @param value Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("lkgrbhtklhvmiljp")
    public suspend fun website(`value`: BucketWebsiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.website = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("pbpyhvkjmamcegeq")
    public suspend fun website(argument: suspend BucketWebsiteArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.website = mapped
    }

    /**
     * @param value (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("mkstycqpjuxjvpxq")
    public suspend fun websiteDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteDomain = mapped
    }

    /**
     * @param value (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @JvmName("pcjfuhvgwkdaavec")
    public suspend fun websiteEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteEndpoint = mapped
    }

    internal fun build(): BucketArgs = BucketArgs(
        accelerationStatus = accelerationStatus,
        acl = acl,
        arn = arn,
        bucket = bucket,
        bucketPrefix = bucketPrefix,
        corsRules = corsRules,
        forceDestroy = forceDestroy,
        grants = grants,
        hostedZoneId = hostedZoneId,
        lifecycleRules = lifecycleRules,
        loggings = loggings,
        objectLockConfiguration = objectLockConfiguration,
        policy = policy,
        replicationConfiguration = replicationConfiguration,
        requestPayer = requestPayer,
        serverSideEncryptionConfiguration = serverSideEncryptionConfiguration,
        tags = tags,
        versioning = versioning,
        website = website,
        websiteDomain = websiteDomain,
        websiteEndpoint = websiteEndpoint,
    )
}
