@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketCorsConfigurationV2CorsRule
import com.pulumi.aws.s3.kotlin.outputs.BucketCorsConfigurationV2CorsRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketCorsConfigurationV2].
 */
@PulumiTagMarker
public class BucketCorsConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketCorsConfigurationV2Args = BucketCorsConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketCorsConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketCorsConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketCorsConfigurationV2 {
        val builtJavaResource = com.pulumi.aws.s3.BucketCorsConfigurationV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketCorsConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket CORS configuration resource. For more information about CORS, go to [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/userguide/cors.html) in the Amazon S3 User Guide.
 * > **NOTE:** S3 Buckets only support a single CORS configuration. Declaring multiple `aws.s3.BucketCorsConfigurationV2` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "mybucket"});
 * const exampleBucketCorsConfigurationV2 = new aws.s3.BucketCorsConfigurationV2("example", {
 *     bucket: example.id,
 *     corsRules: [
 *         {
 *             allowedHeaders: ["*"],
 *             allowedMethods: [
 *                 "PUT",
 *                 "POST",
 *             ],
 *             allowedOrigins: ["https://s3-website-test&#46;domain&#46;example"],
 *             exposeHeaders: ["ETag"],
 *             maxAgeSeconds: 3000,
 *         },
 *         {
 *             allowedMethods: ["GET"],
 *             allowedOrigins: ["*"],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="mybucket")
 * example_bucket_cors_configuration_v2 = aws.s3.BucketCorsConfigurationV2("example",
 *     bucket=example.id,
 *     cors_rules=[
 *         {
 *             "allowed_headers": ["*"],
 *             "allowed_methods": [
 *                 "PUT",
 *                 "POST",
 *             ],
 *             "allowed_origins": ["https://s3-website-test&#46;domain&#46;example"],
 *             "expose_headers": ["ETag"],
 *             "max_age_seconds": 3000,
 *         },
 *         {
 *             "allowed_methods": ["GET"],
 *             "allowed_origins": ["*"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "mybucket",
 *     });
 *     var exampleBucketCorsConfigurationV2 = new Aws.S3.BucketCorsConfigurationV2("example", new()
 *     {
 *         Bucket = example.Id,
 *         CorsRules = new[]
 *         {
 *             new Aws.S3.Inputs.BucketCorsConfigurationV2CorsRuleArgs
 *             {
 *                 AllowedHeaders = new[]
 *                 {
 *                     "*",
 *                 },
 *                 AllowedMethods = new[]
 *                 {
 *                     "PUT",
 *                     "POST",
 *                 },
 *                 AllowedOrigins = new[]
 *                 {
 *                     "https://s3-website-test.domain.example",
 *                 },
 *                 ExposeHeaders = new[]
 *                 {
 *                     "ETag",
 *                 },
 *                 MaxAgeSeconds = 3000,
 *             },
 *             new Aws.S3.Inputs.BucketCorsConfigurationV2CorsRuleArgs
 *             {
 *                 AllowedMethods = new[]
 *                 {
 *                     "GET",
 *                 },
 *                 AllowedOrigins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("mybucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketCorsConfigurationV2(ctx, "example", &s3.BucketCorsConfigurationV2Args{
 * 			Bucket: example.ID(),
 * 			CorsRules: s3.BucketCorsConfigurationV2CorsRuleArray{
 * 				&s3.BucketCorsConfigurationV2CorsRuleArgs{
 * 					AllowedHeaders: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("PUT"),
 * 						pulumi.String("POST"),
 * 					},
 * 					AllowedOrigins: pulumi.StringArray{
 * 						pulumi.String("https://s3-website-test.domain.example"),
 * 					},
 * 					ExposeHeaders: pulumi.StringArray{
 * 						pulumi.String("ETag"),
 * 					},
 * 					MaxAgeSeconds: pulumi.Int(3000),
 * 				},
 * 				&s3.BucketCorsConfigurationV2CorsRuleArgs{
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 					},
 * 					AllowedOrigins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketCorsConfigurationV2;
 * import com.pulumi.aws.s3.BucketCorsConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("mybucket")
 *             .build());
 *         var exampleBucketCorsConfigurationV2 = new BucketCorsConfigurationV2("exampleBucketCorsConfigurationV2", BucketCorsConfigurationV2Args.builder()
 *             .bucket(example.id())
 *             .corsRules(
 *                 BucketCorsConfigurationV2CorsRuleArgs.builder()
 *                     .allowedHeaders("*")
 *                     .allowedMethods(
 *                         "PUT",
 *                         "POST")
 *                     .allowedOrigins("https://s3-website-test.domain.example")
 *                     .exposeHeaders("ETag")
 *                     .maxAgeSeconds(3000)
 *                     .build(),
 *                 BucketCorsConfigurationV2CorsRuleArgs.builder()
 *                     .allowedMethods("GET")
 *                     .allowedOrigins("*")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: mybucket
 *   exampleBucketCorsConfigurationV2:
 *     type: aws:s3:BucketCorsConfigurationV2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       corsRules:
 *         - allowedHeaders:
 *             - '*'
 *           allowedMethods:
 *             - PUT
 *             - POST
 *           allowedOrigins:
 *             - https://s3-website-test.domain.example
 *           exposeHeaders:
 *             - ETag
 *           maxAgeSeconds: 3000
 *         - allowedMethods:
 *             - GET
 *           allowedOrigins:
 *             - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket CORS configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketCorsConfigurationV2:BucketCorsConfigurationV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketCorsConfigurationV2:BucketCorsConfigurationV2 example bucket-name,123456789012
 * ```
 */
public class BucketCorsConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketCorsConfigurationV2,
) : KotlinCustomResource(javaResource, BucketCorsConfigurationV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    public val corsRules: Output<List<BucketCorsConfigurationV2CorsRule>>
        get() = javaResource.corsRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketCorsConfigurationV2Mapper : ResourceMapper<BucketCorsConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketCorsConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketCorsConfigurationV2 =
        BucketCorsConfigurationV2(javaResource as com.pulumi.aws.s3.BucketCorsConfigurationV2)
}

/**
 * @see [BucketCorsConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketCorsConfigurationV2].
 */
public suspend fun bucketCorsConfigurationV2(
    name: String,
    block: suspend BucketCorsConfigurationV2ResourceBuilder.() -> Unit,
): BucketCorsConfigurationV2 {
    val builder = BucketCorsConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketCorsConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketCorsConfigurationV2(name: String): BucketCorsConfigurationV2 {
    val builder = BucketCorsConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
