@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketCorsConfigurationV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketCorsConfigurationV2CorsRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketCorsConfigurationV2CorsRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket CORS configuration resource. For more information about CORS, go to [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/userguide/cors.html) in the Amazon S3 User Guide.
 * > **NOTE:** S3 Buckets only support a single CORS configuration. Declaring multiple `aws.s3.BucketCorsConfigurationV2` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "mybucket"});
 * const exampleBucketCorsConfigurationV2 = new aws.s3.BucketCorsConfigurationV2("example", {
 *     bucket: example.id,
 *     corsRules: [
 *         {
 *             allowedHeaders: ["*"],
 *             allowedMethods: [
 *                 "PUT",
 *                 "POST",
 *             ],
 *             allowedOrigins: ["https://s3-website-test&#46;domain&#46;example"],
 *             exposeHeaders: ["ETag"],
 *             maxAgeSeconds: 3000,
 *         },
 *         {
 *             allowedMethods: ["GET"],
 *             allowedOrigins: ["*"],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="mybucket")
 * example_bucket_cors_configuration_v2 = aws.s3.BucketCorsConfigurationV2("example",
 *     bucket=example.id,
 *     cors_rules=[
 *         {
 *             "allowed_headers": ["*"],
 *             "allowed_methods": [
 *                 "PUT",
 *                 "POST",
 *             ],
 *             "allowed_origins": ["https://s3-website-test&#46;domain&#46;example"],
 *             "expose_headers": ["ETag"],
 *             "max_age_seconds": 3000,
 *         },
 *         {
 *             "allowed_methods": ["GET"],
 *             "allowed_origins": ["*"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "mybucket",
 *     });
 *     var exampleBucketCorsConfigurationV2 = new Aws.S3.BucketCorsConfigurationV2("example", new()
 *     {
 *         Bucket = example.Id,
 *         CorsRules = new[]
 *         {
 *             new Aws.S3.Inputs.BucketCorsConfigurationV2CorsRuleArgs
 *             {
 *                 AllowedHeaders = new[]
 *                 {
 *                     "*",
 *                 },
 *                 AllowedMethods = new[]
 *                 {
 *                     "PUT",
 *                     "POST",
 *                 },
 *                 AllowedOrigins = new[]
 *                 {
 *                     "https://s3-website-test.domain.example",
 *                 },
 *                 ExposeHeaders = new[]
 *                 {
 *                     "ETag",
 *                 },
 *                 MaxAgeSeconds = 3000,
 *             },
 *             new Aws.S3.Inputs.BucketCorsConfigurationV2CorsRuleArgs
 *             {
 *                 AllowedMethods = new[]
 *                 {
 *                     "GET",
 *                 },
 *                 AllowedOrigins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("mybucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketCorsConfigurationV2(ctx, "example", &s3.BucketCorsConfigurationV2Args{
 * 			Bucket: example.ID(),
 * 			CorsRules: s3.BucketCorsConfigurationV2CorsRuleArray{
 * 				&s3.BucketCorsConfigurationV2CorsRuleArgs{
 * 					AllowedHeaders: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("PUT"),
 * 						pulumi.String("POST"),
 * 					},
 * 					AllowedOrigins: pulumi.StringArray{
 * 						pulumi.String("https://s3-website-test.domain.example"),
 * 					},
 * 					ExposeHeaders: pulumi.StringArray{
 * 						pulumi.String("ETag"),
 * 					},
 * 					MaxAgeSeconds: pulumi.Int(3000),
 * 				},
 * 				&s3.BucketCorsConfigurationV2CorsRuleArgs{
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 					},
 * 					AllowedOrigins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketCorsConfigurationV2;
 * import com.pulumi.aws.s3.BucketCorsConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("mybucket")
 *             .build());
 *         var exampleBucketCorsConfigurationV2 = new BucketCorsConfigurationV2("exampleBucketCorsConfigurationV2", BucketCorsConfigurationV2Args.builder()
 *             .bucket(example.id())
 *             .corsRules(
 *                 BucketCorsConfigurationV2CorsRuleArgs.builder()
 *                     .allowedHeaders("*")
 *                     .allowedMethods(
 *                         "PUT",
 *                         "POST")
 *                     .allowedOrigins("https://s3-website-test.domain.example")
 *                     .exposeHeaders("ETag")
 *                     .maxAgeSeconds(3000)
 *                     .build(),
 *                 BucketCorsConfigurationV2CorsRuleArgs.builder()
 *                     .allowedMethods("GET")
 *                     .allowedOrigins("*")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: mybucket
 *   exampleBucketCorsConfigurationV2:
 *     type: aws:s3:BucketCorsConfigurationV2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       corsRules:
 *         - allowedHeaders:
 *             - '*'
 *           allowedMethods:
 *             - PUT
 *             - POST
 *           allowedOrigins:
 *             - https://s3-website-test.domain.example
 *           exposeHeaders:
 *             - ETag
 *           maxAgeSeconds: 3000
 *         - allowedMethods:
 *             - GET
 *           allowedOrigins:
 *             - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket CORS configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketCorsConfigurationV2:BucketCorsConfigurationV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketCorsConfigurationV2:BucketCorsConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property corsRules Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 */
public data class BucketCorsConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val corsRules: Output<List<BucketCorsConfigurationV2CorsRuleArgs>>? = null,
    public val expectedBucketOwner: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketCorsConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketCorsConfigurationV2Args =
        com.pulumi.aws.s3.BucketCorsConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .corsRules(
                corsRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketCorsConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketCorsConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var corsRules: Output<List<BucketCorsConfigurationV2CorsRuleArgs>>? = null

    private var expectedBucketOwner: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("skqhhlmdeobkprmx")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("txeqlxtxlepxtgim")
    public suspend fun corsRules(`value`: Output<List<BucketCorsConfigurationV2CorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("pwuskunlwgdbsjug")
    public suspend fun corsRules(vararg values: Output<BucketCorsConfigurationV2CorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("pivixxmmcayuqohn")
    public suspend fun corsRules(values: List<Output<BucketCorsConfigurationV2CorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("pgejyeloraggiahg")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("ppodjpepjalayrfu")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("nqhkbtjifkbubgbi")
    public suspend fun corsRules(`value`: List<BucketCorsConfigurationV2CorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("bjynkhfudiedmlov")
    public suspend fun corsRules(argument: List<suspend BucketCorsConfigurationV2CorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketCorsConfigurationV2CorsRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("euonkqwiiqrtsstv")
    public suspend fun corsRules(vararg argument: suspend BucketCorsConfigurationV2CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketCorsConfigurationV2CorsRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("lpdooxjhoortlfro")
    public suspend fun corsRules(argument: suspend BucketCorsConfigurationV2CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketCorsConfigurationV2CorsRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     */
    @JvmName("gnncabmhcnghncbl")
    public suspend fun corsRules(vararg values: BucketCorsConfigurationV2CorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("bnearakdnhnguebr")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    internal fun build(): BucketCorsConfigurationV2Args = BucketCorsConfigurationV2Args(
        bucket = bucket,
        corsRules = corsRules,
        expectedBucketOwner = expectedBucketOwner,
    )
}
