@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationFilterArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationTieringArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationTieringArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an [S3 Intelligent-Tiering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html) configuration resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add intelligent tiering configuration for entire S3 bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const example_entire_bucket = new aws.s3.BucketIntelligentTieringConfiguration("example-entire-bucket", {
 *     bucket: example.id,
 *     name: "EntireBucket",
 *     tierings: [
 *         {
 *             accessTier: "DEEP_ARCHIVE_ACCESS",
 *             days: 180,
 *         },
 *         {
 *             accessTier: "ARCHIVE_ACCESS",
 *             days: 125,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_entire_bucket = aws.s3.BucketIntelligentTieringConfiguration("example-entire-bucket",
 *     bucket=example.id,
 *     name="EntireBucket",
 *     tierings=[
 *         {
 *             "access_tier": "DEEP_ARCHIVE_ACCESS",
 *             "days": 180,
 *         },
 *         {
 *             "access_tier": "ARCHIVE_ACCESS",
 *             "days": 125,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var example_entire_bucket = new Aws.S3.BucketIntelligentTieringConfiguration("example-entire-bucket", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "EntireBucket",
 *         Tierings = new[]
 *         {
 *             new Aws.S3.Inputs.BucketIntelligentTieringConfigurationTieringArgs
 *             {
 *                 AccessTier = "DEEP_ARCHIVE_ACCESS",
 *                 Days = 180,
 *             },
 *             new Aws.S3.Inputs.BucketIntelligentTieringConfigurationTieringArgs
 *             {
 *                 AccessTier = "ARCHIVE_ACCESS",
 *                 Days = 125,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketIntelligentTieringConfiguration(ctx, "example-entire-bucket", &s3.BucketIntelligentTieringConfigurationArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("EntireBucket"),
 * 			Tierings: s3.BucketIntelligentTieringConfigurationTieringArray{
 * 				&s3.BucketIntelligentTieringConfigurationTieringArgs{
 * 					AccessTier: pulumi.String("DEEP_ARCHIVE_ACCESS"),
 * 					Days:       pulumi.Int(180),
 * 				},
 * 				&s3.BucketIntelligentTieringConfigurationTieringArgs{
 * 					AccessTier: pulumi.String("ARCHIVE_ACCESS"),
 * 					Days:       pulumi.Int(125),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var example_entire_bucket = new BucketIntelligentTieringConfiguration("example-entire-bucket", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .name("EntireBucket")
 *             .tierings(
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("DEEP_ARCHIVE_ACCESS")
 *                     .days(180)
 *                     .build(),
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("ARCHIVE_ACCESS")
 *                     .days(125)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example-entire-bucket:
 *     type: aws:s3:BucketIntelligentTieringConfiguration
 *     properties:
 *       bucket: ${example.id}
 *       name: EntireBucket
 *       tierings:
 *         - accessTier: DEEP_ARCHIVE_ACCESS
 *           days: 180
 *         - accessTier: ARCHIVE_ACCESS
 *           days: 125
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Add intelligent tiering configuration with S3 object filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const example_filtered = new aws.s3.BucketIntelligentTieringConfiguration("example-filtered", {
 *     bucket: example.id,
 *     name: "ImportantBlueDocuments",
 *     status: "Disabled",
 *     filter: {
 *         prefix: "documents/",
 *         tags: {
 *             priority: "high",
 *             "class": "blue",
 *         },
 *     },
 *     tierings: [{
 *         accessTier: "ARCHIVE_ACCESS",
 *         days: 125,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_filtered = aws.s3.BucketIntelligentTieringConfiguration("example-filtered",
 *     bucket=example.id,
 *     name="ImportantBlueDocuments",
 *     status="Disabled",
 *     filter={
 *         "prefix": "documents/",
 *         "tags": {
 *             "priority": "high",
 *             "class_": "blue",
 *         },
 *     },
 *     tierings=[{
 *         "access_tier": "ARCHIVE_ACCESS",
 *         "days": 125,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var example_filtered = new Aws.S3.BucketIntelligentTieringConfiguration("example-filtered", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "ImportantBlueDocuments",
 *         Status = "Disabled",
 *         Filter = new Aws.S3.Inputs.BucketIntelligentTieringConfigurationFilterArgs
 *         {
 *             Prefix = "documents/",
 *             Tags =
 *             {
 *                 { "priority", "high" },
 *                 { "class", "blue" },
 *             },
 *         },
 *         Tierings = new[]
 *         {
 *             new Aws.S3.Inputs.BucketIntelligentTieringConfigurationTieringArgs
 *             {
 *                 AccessTier = "ARCHIVE_ACCESS",
 *                 Days = 125,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketIntelligentTieringConfiguration(ctx, "example-filtered", &s3.BucketIntelligentTieringConfigurationArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("ImportantBlueDocuments"),
 * 			Status: pulumi.String("Disabled"),
 * 			Filter: &s3.BucketIntelligentTieringConfigurationFilterArgs{
 * 				Prefix: pulumi.String("documents/"),
 * 				Tags: pulumi.StringMap{
 * 					"priority": pulumi.String("high"),
 * 					"class":    pulumi.String("blue"),
 * 				},
 * 			},
 * 			Tierings: s3.BucketIntelligentTieringConfigurationTieringArray{
 * 				&s3.BucketIntelligentTieringConfigurationTieringArgs{
 * 					AccessTier: pulumi.String("ARCHIVE_ACCESS"),
 * 					Days:       pulumi.Int(125),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var example_filtered = new BucketIntelligentTieringConfiguration("example-filtered", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .name("ImportantBlueDocuments")
 *             .status("Disabled")
 *             .filter(BucketIntelligentTieringConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .tierings(BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                 .accessTier("ARCHIVE_ACCESS")
 *                 .days(125)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example-filtered:
 *     type: aws:s3:BucketIntelligentTieringConfiguration
 *     properties:
 *       bucket: ${example.id}
 *       name: ImportantBlueDocuments
 *       status: Disabled
 *       filter:
 *         prefix: documents/
 *         tags:
 *           priority: high
 *           class: blue
 *       tierings:
 *         - accessTier: ARCHIVE_ACCESS
 *           days: 125
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket intelligent tiering configurations using `bucket:name`. For example:
 * ```sh
 * $ pulumi import aws:s3/bucketIntelligentTieringConfiguration:BucketIntelligentTieringConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the bucket this intelligent tiering configuration is associated with.
 * @property filter Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
 * @property name Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
 * @property status Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
 * @property tierings S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
 */
public data class BucketIntelligentTieringConfigurationArgs(
    public val bucket: Output<String>? = null,
    public val filter: Output<BucketIntelligentTieringConfigurationFilterArgs>? = null,
    public val name: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tierings: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs =
        com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tierings(
                tierings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketIntelligentTieringConfigurationArgs].
 */
@PulumiTagMarker
public class BucketIntelligentTieringConfigurationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var filter: Output<BucketIntelligentTieringConfigurationFilterArgs>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    private var tierings: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>? = null

    /**
     * @param value Name of the bucket this intelligent tiering configuration is associated with.
     */
    @JvmName("dunyakxhqxocoxfp")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("vtwqmtdcgjnmaphs")
    public suspend fun filter(`value`: Output<BucketIntelligentTieringConfigurationFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
     */
    @JvmName("otionmmpahnhbndo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("fexthjchktkbyhrg")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("bmymkibdbrkeghrd")
    public suspend fun tierings(`value`: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>) {
        this.tierings = value
    }

    @JvmName("ypvsuxwwwmxbyqoq")
    public suspend fun tierings(vararg values: Output<BucketIntelligentTieringConfigurationTieringArgs>) {
        this.tierings = Output.all(values.asList())
    }

    /**
     * @param values S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("dhgpodoycbcjnbjj")
    public suspend fun tierings(values: List<Output<BucketIntelligentTieringConfigurationTieringArgs>>) {
        this.tierings = Output.all(values)
    }

    /**
     * @param value Name of the bucket this intelligent tiering configuration is associated with.
     */
    @JvmName("gjelyalsdlgkidgv")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("mlookonwrqojbqjv")
    public suspend fun filter(`value`: BucketIntelligentTieringConfigurationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("xjnspbhhlsiiiiop")
    public suspend fun filter(argument: suspend BucketIntelligentTieringConfigurationFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketIntelligentTieringConfigurationFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
     */
    @JvmName("twiuvibbupvujpiy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("isadnrmcxkydrwqh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("oybouhiaolyttmed")
    public suspend fun tierings(`value`: List<BucketIntelligentTieringConfigurationTieringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("tldvlrwywlstfrck")
    public suspend fun tierings(argument: List<suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("hsvlqqbwsmfdhbvm")
    public suspend fun tierings(vararg argument: suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("hmjhbchghleelkgf")
    public suspend fun tierings(argument: suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param values S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("ejyjcofnwfuhcxru")
    public suspend fun tierings(vararg values: BucketIntelligentTieringConfigurationTieringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tierings = mapped
    }

    internal fun build(): BucketIntelligentTieringConfigurationArgs =
        BucketIntelligentTieringConfigurationArgs(
            bucket = bucket,
            filter = filter,
            name = name,
            status = status,
            tierings = tierings,
        )
}
