@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetGrant
import com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetObjectKeyFormat
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetGrant.Companion.toKotlin as bucketLoggingV2TargetGrantToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetObjectKeyFormat.Companion.toKotlin as bucketLoggingV2TargetObjectKeyFormatToKotlin

/**
 * Builder for [BucketLoggingV2].
 */
@PulumiTagMarker
public class BucketLoggingV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketLoggingV2Args = BucketLoggingV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketLoggingV2ArgsBuilder.() -> Unit) {
        val builder = BucketLoggingV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketLoggingV2 {
        val builtJavaResource = com.pulumi.aws.s3.BucketLoggingV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketLoggingV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket (server access) logging resource. For more information, see [Logging requests using server access logging](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html)
 * in the AWS S3 User Guide.
 * > **Note:** Amazon S3 supports server access logging, AWS CloudTrail, or a combination of both. Refer to the [Logging options for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/logging-with-S3.html)
 * to decide which method meets your requirements.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "my-tf-example-bucket"});
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: example.id,
 *     acl: "private",
 * });
 * const logBucket = new aws.s3.BucketV2("log_bucket", {bucket: "my-tf-log-bucket"});
 * const logBucketAcl = new aws.s3.BucketAclV2("log_bucket_acl", {
 *     bucket: logBucket.id,
 *     acl: "log-delivery-write",
 * });
 * const exampleBucketLoggingV2 = new aws.s3.BucketLoggingV2("example", {
 *     bucket: example.id,
 *     targetBucket: logBucket.id,
 *     targetPrefix: "log/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="my-tf-example-bucket")
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example.id,
 *     acl="private")
 * log_bucket = aws.s3.BucketV2("log_bucket", bucket="my-tf-log-bucket")
 * log_bucket_acl = aws.s3.BucketAclV2("log_bucket_acl",
 *     bucket=log_bucket.id,
 *     acl="log-delivery-write")
 * example_bucket_logging_v2 = aws.s3.BucketLoggingV2("example",
 *     bucket=example.id,
 *     target_bucket=log_bucket.id,
 *     target_prefix="log/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-tf-example-bucket",
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = example.Id,
 *         Acl = "private",
 *     });
 *     var logBucket = new Aws.S3.BucketV2("log_bucket", new()
 *     {
 *         Bucket = "my-tf-log-bucket",
 *     });
 *     var logBucketAcl = new Aws.S3.BucketAclV2("log_bucket_acl", new()
 *     {
 *         Bucket = logBucket.Id,
 *         Acl = "log-delivery-write",
 *     });
 *     var exampleBucketLoggingV2 = new Aws.S3.BucketLoggingV2("example", new()
 *     {
 *         Bucket = example.Id,
 *         TargetBucket = logBucket.Id,
 *         TargetPrefix = "log/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-example-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * 			Bucket: example.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		logBucket, err := s3.NewBucketV2(ctx, "log_bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-log-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "log_bucket_acl", &s3.BucketAclV2Args{
 * 			Bucket: logBucket.ID(),
 * 			Acl:    pulumi.String("log-delivery-write"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketLoggingV2(ctx, "example", &s3.BucketLoggingV2Args{
 * 			Bucket:       example.ID(),
 * 			TargetBucket: logBucket.ID(),
 * 			TargetPrefix: pulumi.String("log/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketLoggingV2;
 * import com.pulumi.aws.s3.BucketLoggingV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("my-tf-example-bucket")
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(example.id())
 *             .acl("private")
 *             .build());
 *         var logBucket = new BucketV2("logBucket", BucketV2Args.builder()
 *             .bucket("my-tf-log-bucket")
 *             .build());
 *         var logBucketAcl = new BucketAclV2("logBucketAcl", BucketAclV2Args.builder()
 *             .bucket(logBucket.id())
 *             .acl("log-delivery-write")
 *             .build());
 *         var exampleBucketLoggingV2 = new BucketLoggingV2("exampleBucketLoggingV2", BucketLoggingV2Args.builder()
 *             .bucket(example.id())
 *             .targetBucket(logBucket.id())
 *             .targetPrefix("log/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-example-bucket
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       acl: private
 *   logBucket:
 *     type: aws:s3:BucketV2
 *     name: log_bucket
 *     properties:
 *       bucket: my-tf-log-bucket
 *   logBucketAcl:
 *     type: aws:s3:BucketAclV2
 *     name: log_bucket_acl
 *     properties:
 *       bucket: ${logBucket.id}
 *       acl: log-delivery-write
 *   exampleBucketLoggingV2:
 *     type: aws:s3:BucketLoggingV2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       targetBucket: ${logBucket.id}
 *       targetPrefix: log/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket logging using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketLoggingV2:BucketLoggingV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketLoggingV2:BucketLoggingV2 example bucket-name,123456789012
 * ```
 */
public class BucketLoggingV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketLoggingV2,
) : KotlinCustomResource(javaResource, BucketLoggingV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the bucket where you want Amazon S3 to store server access logs.
     */
    public val targetBucket: Output<String>
        get() = javaResource.targetBucket().applyValue({ args0 -> args0 })

    /**
     * Set of configuration blocks with information for granting permissions. See below.
     */
    public val targetGrants: Output<List<BucketLoggingV2TargetGrant>>?
        get() = javaResource.targetGrants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketLoggingV2TargetGrantToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Amazon S3 key format for log objects. See below.
     */
    public val targetObjectKeyFormat: Output<BucketLoggingV2TargetObjectKeyFormat>?
        get() = javaResource.targetObjectKeyFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketLoggingV2TargetObjectKeyFormatToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Prefix for all log object keys.
     */
    public val targetPrefix: Output<String>
        get() = javaResource.targetPrefix().applyValue({ args0 -> args0 })
}

public object BucketLoggingV2Mapper : ResourceMapper<BucketLoggingV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketLoggingV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketLoggingV2 = BucketLoggingV2(
        javaResource as
            com.pulumi.aws.s3.BucketLoggingV2,
    )
}

/**
 * @see [BucketLoggingV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketLoggingV2].
 */
public suspend fun bucketLoggingV2(
    name: String,
    block: suspend BucketLoggingV2ResourceBuilder.() -> Unit,
): BucketLoggingV2 {
    val builder = BucketLoggingV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketLoggingV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketLoggingV2(name: String): BucketLoggingV2 {
    val builder = BucketLoggingV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
