@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketOwnershipControlsRule
import com.pulumi.aws.s3.kotlin.outputs.BucketOwnershipControlsRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketOwnershipControls].
 */
@PulumiTagMarker
public class BucketOwnershipControlsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketOwnershipControlsArgs = BucketOwnershipControlsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketOwnershipControlsArgsBuilder.() -> Unit) {
        val builder = BucketOwnershipControlsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketOwnershipControls {
        val builtJavaResource = com.pulumi.aws.s3.BucketOwnershipControls(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketOwnershipControls(builtJavaResource)
    }
}

/**
 * Provides a resource to manage S3 Bucket Ownership Controls. For more information, see the [S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketOwnershipControls = new aws.s3.BucketOwnershipControls("example", {
 *     bucket: example.id,
 *     rule: {
 *         objectOwnership: "BucketOwnerPreferred",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
 *     bucket=example.id,
 *     rule={
 *         "object_ownership": "BucketOwnerPreferred",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketOwnershipControls = new Aws.S3.BucketOwnershipControls("example", new()
 *     {
 *         Bucket = example.Id,
 *         Rule = new Aws.S3.Inputs.BucketOwnershipControlsRuleArgs
 *         {
 *             ObjectOwnership = "BucketOwnerPreferred",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketOwnershipControls(ctx, "example", &s3.BucketOwnershipControlsArgs{
 * 			Bucket: example.ID(),
 * 			Rule: &s3.BucketOwnershipControlsRuleArgs{
 * 				ObjectOwnership: pulumi.String("BucketOwnerPreferred"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(example.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleBucketOwnershipControls:
 *     type: aws:s3:BucketOwnershipControls
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       rule:
 *         objectOwnership: BucketOwnerPreferred
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Bucket Ownership Controls using S3 Bucket name. For example:
 * ```sh
 * $ pulumi import aws:s3/bucketOwnershipControls:BucketOwnershipControls example my-bucket
 * ```
 */
public class BucketOwnershipControls internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketOwnershipControls,
) : KotlinCustomResource(javaResource, BucketOwnershipControlsMapper) {
    /**
     * Name of the bucket that you want to associate this access point with.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    public val rule: Output<BucketOwnershipControlsRule>
        get() = javaResource.rule().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object BucketOwnershipControlsMapper : ResourceMapper<BucketOwnershipControls> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketOwnershipControls::class == javaResource::class

    override fun map(javaResource: Resource): BucketOwnershipControls =
        BucketOwnershipControls(javaResource as com.pulumi.aws.s3.BucketOwnershipControls)
}

/**
 * @see [BucketOwnershipControls].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketOwnershipControls].
 */
public suspend fun bucketOwnershipControls(
    name: String,
    block: suspend BucketOwnershipControlsResourceBuilder.() -> Unit,
): BucketOwnershipControls {
    val builder = BucketOwnershipControlsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketOwnershipControls].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketOwnershipControls(name: String): BucketOwnershipControls {
    val builder = BucketOwnershipControlsResourceBuilder()
    builder.name(name)
    return builder.build()
}
