@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketOwnershipControlsArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketOwnershipControlsRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketOwnershipControlsRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage S3 Bucket Ownership Controls. For more information, see the [S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketOwnershipControls = new aws.s3.BucketOwnershipControls("example", {
 *     bucket: example.id,
 *     rule: {
 *         objectOwnership: "BucketOwnerPreferred",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
 *     bucket=example.id,
 *     rule={
 *         "object_ownership": "BucketOwnerPreferred",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketOwnershipControls = new Aws.S3.BucketOwnershipControls("example", new()
 *     {
 *         Bucket = example.Id,
 *         Rule = new Aws.S3.Inputs.BucketOwnershipControlsRuleArgs
 *         {
 *             ObjectOwnership = "BucketOwnerPreferred",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketOwnershipControls(ctx, "example", &s3.BucketOwnershipControlsArgs{
 * 			Bucket: example.ID(),
 * 			Rule: &s3.BucketOwnershipControlsRuleArgs{
 * 				ObjectOwnership: pulumi.String("BucketOwnerPreferred"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(example.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleBucketOwnershipControls:
 *     type: aws:s3:BucketOwnershipControls
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       rule:
 *         objectOwnership: BucketOwnerPreferred
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Bucket Ownership Controls using S3 Bucket name. For example:
 * ```sh
 * $ pulumi import aws:s3/bucketOwnershipControls:BucketOwnershipControls example my-bucket
 * ```
 * @property bucket Name of the bucket that you want to associate this access point with.
 * @property rule Configuration block(s) with Ownership Controls rules. Detailed below.
 */
public data class BucketOwnershipControlsArgs(
    public val bucket: Output<String>? = null,
    public val rule: Output<BucketOwnershipControlsRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketOwnershipControlsArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketOwnershipControlsArgs =
        com.pulumi.aws.s3.BucketOwnershipControlsArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketOwnershipControlsArgs].
 */
@PulumiTagMarker
public class BucketOwnershipControlsArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var rule: Output<BucketOwnershipControlsRuleArgs>? = null

    /**
     * @param value Name of the bucket that you want to associate this access point with.
     */
    @JvmName("mpreqcowtauabxuc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("msjfsdesktftqvwx")
    public suspend fun rule(`value`: Output<BucketOwnershipControlsRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value Name of the bucket that you want to associate this access point with.
     */
    @JvmName("odrnripvtpakesvi")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("ngcjobcfpxbqqkfg")
    public suspend fun rule(`value`: BucketOwnershipControlsRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("ontqwirfknftaiwd")
    public suspend fun rule(argument: suspend BucketOwnershipControlsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketOwnershipControlsRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    internal fun build(): BucketOwnershipControlsArgs = BucketOwnershipControlsArgs(
        bucket = bucket,
        rule = rule,
    )
}
