@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRule
import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketReplicationConfig].
 */
@PulumiTagMarker
public class BucketReplicationConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketReplicationConfigArgs = BucketReplicationConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketReplicationConfigArgsBuilder.() -> Unit) {
        val builder = BucketReplicationConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketReplicationConfig {
        val builtJavaResource = com.pulumi.aws.s3.BucketReplicationConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketReplicationConfig(builtJavaResource)
    }
}

/**
 * Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).
 * > **NOTE:** S3 Buckets only support a single replication configuration. Declaring multiple `aws.s3.BucketReplicationConfig` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Using replication configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["s3&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const replicationRole = new aws.iam.Role("replication", {
 *     name: "tf-iam-role-replication-12345",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const destination = new aws.s3.BucketV2("destination", {bucket: "tf-test-bucket-destination-12345"});
 * const source = new aws.s3.BucketV2("source", {bucket: "tf-test-bucket-source-12345"});
 * const replication = aws.iam.getPolicyDocumentOutput({
 *     statements: [
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "s3:GetReplicationConfiguration",
 *                 "s3:ListBucket",
 *             ],
 *             resources: [source&#46;arn],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "s3:GetObjectVersionForReplication",
 *                 "s3:GetObjectVersionAcl",
 *                 "s3:GetObjectVersionTagging",
 *             ],
 *             resources: [pulumi&#46;interpolate`${source&#46;arn}/*`],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "s3:ReplicateObject",
 *                 "s3:ReplicateDelete",
 *                 "s3:ReplicateTags",
 *             ],
 *             resources: [pulumi&#46;interpolate`${destination&#46;arn}/*`],
 *         },
 *     ],
 * });
 * const replicationPolicy = new aws.iam.Policy("replication", {
 *     name: "tf-iam-role-policy-replication-12345",
 *     policy: replication.apply(replication => replication.json),
 * });
 * const replicationRolePolicyAttachment = new aws.iam.RolePolicyAttachment("replication", {
 *     role: replicationRole.name,
 *     policyArn: replicationPolicy.arn,
 * });
 * const destinationBucketVersioningV2 = new aws.s3.BucketVersioningV2("destination", {
 *     bucket: destination.id,
 *     versioningConfiguration: {
 *         status: "Enabled",
 *     },
 * });
 * const sourceBucketAcl = new aws.s3.BucketAclV2("source_bucket_acl", {
 *     bucket: source.id,
 *     acl: "private",
 * });
 * const sourceBucketVersioningV2 = new aws.s3.BucketVersioningV2("source", {
 *     bucket: source.id,
 *     versioningConfiguration: {
 *         status: "Enabled",
 *     },
 * });
 * const replicationBucketReplicationConfig = new aws.s3.BucketReplicationConfig("replication", {
 *     role: replicationRole.arn,
 *     bucket: source.id,
 *     rules: [{
 *         id: "foobar",
 *         filter: {
 *             prefix: "foo",
 *         },
 *         status: "Enabled",
 *         destination: {
 *             bucket: destination.arn,
 *             storageClass: "STANDARD",
 *         },
 *     }],
 * }, {
 *     dependsOn: [sourceBucketVersioningV2],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["s3&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * replication_role = aws.iam.Role("replication",
 *     name="tf-iam-role-replication-12345",
 *     assume_role_policy=assume_role.json)
 * destination = aws.s3.BucketV2("destination", bucket="tf-test-bucket-destination-12345")
 * source = aws.s3.BucketV2("source", bucket="tf-test-bucket-source-12345")
 * replication = aws.iam.get_policy_document_output(statements=[
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "s3:GetReplicationConfiguration",
 *             "s3:ListBucket",
 *         ],
 *         "resources": [source&#46;arn],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "s3:GetObjectVersionForReplication",
 *             "s3:GetObjectVersionAcl",
 *             "s3:GetObjectVersionTagging",
 *         ],
 *         "resources": [source&#46;arn&#46;apply(lambda arn: f"{arn}/*")],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "s3:ReplicateObject",
 *             "s3:ReplicateDelete",
 *             "s3:ReplicateTags",
 *         ],
 *         "resources": [destination&#46;arn&#46;apply(lambda arn: f"{arn}/*")],
 *     },
 * ])
 * replication_policy = aws.iam.Policy("replication",
 *     name="tf-iam-role-policy-replication-12345",
 *     policy=replication.json)
 * replication_role_policy_attachment = aws.iam.RolePolicyAttachment("replication",
 *     role=replication_role.name,
 *     policy_arn=replication_policy.arn)
 * destination_bucket_versioning_v2 = aws.s3.BucketVersioningV2("destination",
 *     bucket=destination.id,
 *     versioning_configuration={
 *         "status": "Enabled",
 *     })
 * source_bucket_acl = aws.s3.BucketAclV2("source_bucket_acl",
 *     bucket=source.id,
 *     acl="private")
 * source_bucket_versioning_v2 = aws.s3.BucketVersioningV2("source",
 *     bucket=source.id,
 *     versioning_configuration={
 *         "status": "Enabled",
 *     })
 * replication_bucket_replication_config = aws.s3.BucketReplicationConfig("replication",
 *     role=replication_role.arn,
 *     bucket=source.id,
 *     rules=[{
 *         "id": "foobar",
 *         "filter": {
 *             "prefix": "foo",
 *         },
 *         "status": "Enabled",
 *         "destination": {
 *             "bucket": destination.arn,
 *             "storage_class": "STANDARD",
 *         },
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[source_bucket_versioning_v2]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "s3.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var replicationRole = new Aws.Iam.Role("replication", new()
 *     {
 *         Name = "tf-iam-role-replication-12345",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var destination = new Aws.S3.BucketV2("destination", new()
 *     {
 *         Bucket = "tf-test-bucket-destination-12345",
 *     });
 *     var source = new Aws.S3.BucketV2("source", new()
 *     {
 *         Bucket = "tf-test-bucket-source-12345",
 *     });
 *     var replication = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:GetReplicationConfiguration",
 *                     "s3:ListBucket",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     source.Arn,
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:GetObjectVersionForReplication",
 *                     "s3:GetObjectVersionAcl",
 *                     "s3:GetObjectVersionTagging",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{source.Arn}/*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:ReplicateObject",
 *                     "s3:ReplicateDelete",
 *                     "s3:ReplicateTags",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{destination.Arn}/*",
 *                 },
 *             },
 *         },
 *     });
 *     var replicationPolicy = new Aws.Iam.Policy("replication", new()
 *     {
 *         Name = "tf-iam-role-policy-replication-12345",
 *         PolicyDocument = replication.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var replicationRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("replication", new()
 *     {
 *         Role = replicationRole.Name,
 *         PolicyArn = replicationPolicy.Arn,
 *     });
 *     var destinationBucketVersioningV2 = new Aws.S3.BucketVersioningV2("destination", new()
 *     {
 *         Bucket = destination.Id,
 *         VersioningConfiguration = new Aws.S3.Inputs.BucketVersioningV2VersioningConfigurationArgs
 *         {
 *             Status = "Enabled",
 *         },
 *     });
 *     var sourceBucketAcl = new Aws.S3.BucketAclV2("source_bucket_acl", new()
 *     {
 *         Bucket = source.Id,
 *         Acl = "private",
 *     });
 *     var sourceBucketVersioningV2 = new Aws.S3.BucketVersioningV2("source", new()
 *     {
 *         Bucket = source.Id,
 *         VersioningConfiguration = new Aws.S3.Inputs.BucketVersioningV2VersioningConfigurationArgs
 *         {
 *             Status = "Enabled",
 *         },
 *     });
 *     var replicationBucketReplicationConfig = new Aws.S3.BucketReplicationConfig("replication", new()
 *     {
 *         Role = replicationRole.Arn,
 *         Bucket = source.Id,
 *         Rules = new[]
 *         {
 *             new Aws.S3.Inputs.BucketReplicationConfigRuleArgs
 *             {
 *                 Id = "foobar",
 *                 Filter = new Aws.S3.Inputs.BucketReplicationConfigRuleFilterArgs
 *                 {
 *                     Prefix = "foo",
 *                 },
 *                 Status = "Enabled",
 *                 Destination = new Aws.S3.Inputs.BucketReplicationConfigRuleDestinationArgs
 *                 {
 *                     Bucket = destination.Arn,
 *                     StorageClass = "STANDARD",
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             sourceBucketVersioningV2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"s3.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		replicationRole, err := iam.NewRole(ctx, "replication", &iam.RoleArgs{
 * 			Name:             pulumi.String("tf-iam-role-replication-12345"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		destination, err := s3.NewBucketV2(ctx, "destination", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket-destination-12345"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		source, err := s3.NewBucketV2(ctx, "source", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket-source-12345"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		replication := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:GetReplicationConfiguration"),
 * 						pulumi.String("s3:ListBucket"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						source.Arn,
 * 					},
 * 				},
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:GetObjectVersionForReplication"),
 * 						pulumi.String("s3:GetObjectVersionAcl"),
 * 						pulumi.String("s3:GetObjectVersionTagging"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						source.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:ReplicateObject"),
 * 						pulumi.String("s3:ReplicateDelete"),
 * 						pulumi.String("s3:ReplicateTags"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						destination.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		replicationPolicy, err := iam.NewPolicy(ctx, "replication", &iam.PolicyArgs{
 * 			Name: pulumi.String("tf-iam-role-policy-replication-12345"),
 * 			Policy: pulumi.String(replication.ApplyT(func(replication iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &replication.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "replication", &iam.RolePolicyAttachmentArgs{
 * 			Role:      replicationRole.Name,
 * 			PolicyArn: replicationPolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketVersioningV2(ctx, "destination", &s3.BucketVersioningV2Args{
 * 			Bucket: destination.ID(),
 * 			VersioningConfiguration: &s3.BucketVersioningV2VersioningConfigurationArgs{
 * 				Status: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "source_bucket_acl", &s3.BucketAclV2Args{
 * 			Bucket: source.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		sourceBucketVersioningV2, err := s3.NewBucketVersioningV2(ctx, "source", &s3.BucketVersioningV2Args{
 * 			Bucket: source.ID(),
 * 			VersioningConfiguration: &s3.BucketVersioningV2VersioningConfigurationArgs{
 * 				Status: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketReplicationConfig(ctx, "replication", &s3.BucketReplicationConfigArgs{
 * 			Role:   replicationRole.Arn,
 * 			Bucket: source.ID(),
 * 			Rules: s3.BucketReplicationConfigRuleArray{
 * 				&s3.BucketReplicationConfigRuleArgs{
 * 					Id: pulumi.String("foobar"),
 * 					Filter: &s3.BucketReplicationConfigRuleFilterArgs{
 * 						Prefix: pulumi.String("foo"),
 * 					},
 * 					Status: pulumi.String("Enabled"),
 * 					Destination: &s3.BucketReplicationConfigRuleDestinationArgs{
 * 						Bucket:       destination.Arn,
 * 						StorageClass: pulumi.String("STANDARD"),
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			sourceBucketVersioningV2,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("s3.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var replicationRole = new Role("replicationRole", RoleArgs.builder()
 *             .name("tf-iam-role-replication-12345")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var destination = new BucketV2("destination", BucketV2Args.builder()
 *             .bucket("tf-test-bucket-destination-12345")
 *             .build());
 *         var source = new BucketV2("source", BucketV2Args.builder()
 *             .bucket("tf-test-bucket-source-12345")
 *             .build());
 *         final var replication = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetReplicationConfiguration",
 *                         "s3:ListBucket")
 *                     .resources(source.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetObjectVersionForReplication",
 *                         "s3:GetObjectVersionAcl",
 *                         "s3:GetObjectVersionTagging")
 *                     .resources(source.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:ReplicateObject",
 *                         "s3:ReplicateDelete",
 *                         "s3:ReplicateTags")
 *                     .resources(destination.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var replicationPolicy = new Policy("replicationPolicy", PolicyArgs.builder()
 *             .name("tf-iam-role-policy-replication-12345")
 *             .policy(replication.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(replication -> replication.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var replicationRolePolicyAttachment = new RolePolicyAttachment("replicationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(replicationRole.name())
 *             .policyArn(replicationPolicy.arn())
 *             .build());
 *         var destinationBucketVersioningV2 = new BucketVersioningV2("destinationBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(destination.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var sourceBucketAcl = new BucketAclV2("sourceBucketAcl", BucketAclV2Args.builder()
 *             .bucket(source.id())
 *             .acl("private")
 *             .build());
 *         var sourceBucketVersioningV2 = new BucketVersioningV2("sourceBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(source.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var replicationBucketReplicationConfig = new BucketReplicationConfig("replicationBucketReplicationConfig", BucketReplicationConfigArgs.builder()
 *             .role(replicationRole.arn())
 *             .bucket(source.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(destination.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(sourceBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   replicationRole:
 *     type: aws:iam:Role
 *     name: replication
 *     properties:
 *       name: tf-iam-role-replication-12345
 *       assumeRolePolicy: ${assumeRole.json}
 *   replicationPolicy:
 *     type: aws:iam:Policy
 *     name: replication
 *     properties:
 *       name: tf-iam-role-policy-replication-12345
 *       policy: ${replication.json}
 *   replicationRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: replication
 *     properties:
 *       role: ${replicationRole.name}
 *       policyArn: ${replicationPolicy.arn}
 *   destination:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test-bucket-destination-12345
 *   destinationBucketVersioningV2:
 *     type: aws:s3:BucketVersioningV2
 *     name: destination
 *     properties:
 *       bucket: ${destination.id}
 *       versioningConfiguration:
 *         status: Enabled
 *   source:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test-bucket-source-12345
 *   sourceBucketAcl:
 *     type: aws:s3:BucketAclV2
 *     name: source_bucket_acl
 *     properties:
 *       bucket: ${source.id}
 *       acl: private
 *   sourceBucketVersioningV2:
 *     type: aws:s3:BucketVersioningV2
 *     name: source
 *     properties:
 *       bucket: ${source.id}
 *       versioningConfiguration:
 *         status: Enabled
 *   replicationBucketReplicationConfig:
 *     type: aws:s3:BucketReplicationConfig
 *     name: replication
 *     properties:
 *       role: ${replicationRole.arn}
 *       bucket: ${source.id}
 *       rules:
 *         - id: foobar
 *           filter:
 *             prefix: foo
 *           status: Enabled
 *           destination:
 *             bucket: ${destination.arn}
 *             storageClass: STANDARD
 *     options:
 *       dependson:
 *         - ${sourceBucketVersioningV2}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - s3.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   replication:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - s3:GetReplicationConfiguration
 *               - s3:ListBucket
 *             resources:
 *               - ${source.arn}
 *           - effect: Allow
 *             actions:
 *               - s3:GetObjectVersionForReplication
 *               - s3:GetObjectVersionAcl
 *               - s3:GetObjectVersionTagging
 *             resources:
 *               - ${source.arn}/*
 *           - effect: Allow
 *             actions:
 *               - s3:ReplicateObject
 *               - s3:ReplicateDelete
 *               - s3:ReplicateTags
 *             resources:
 *               - ${destination.arn}/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Bi-Directional Replication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ... other configuration ...
 * const east = new aws.s3.BucketV2("east", {bucket: "tf-test-bucket-east-12345"});
 * const eastBucketVersioningV2 = new aws.s3.BucketVersioningV2("east", {
 *     bucket: east.id,
 *     versioningConfiguration: {
 *         status: "Enabled",
 *     },
 * });
 * const west = new aws.s3.BucketV2("west", {bucket: "tf-test-bucket-west-12345"});
 * const westBucketVersioningV2 = new aws.s3.BucketVersioningV2("west", {
 *     bucket: west.id,
 *     versioningConfiguration: {
 *         status: "Enabled",
 *     },
 * });
 * const eastToWest = new aws.s3.BucketReplicationConfig("east_to_west", {
 *     role: eastReplication.arn,
 *     bucket: east.id,
 *     rules: [{
 *         id: "foobar",
 *         filter: {
 *             prefix: "foo",
 *         },
 *         status: "Enabled",
 *         destination: {
 *             bucket: west.arn,
 *             storageClass: "STANDARD",
 *         },
 *     }],
 * }, {
 *     dependsOn: [eastBucketVersioningV2],
 * });
 * const westToEast = new aws.s3.BucketReplicationConfig("west_to_east", {
 *     role: westReplication.arn,
 *     bucket: west.id,
 *     rules: [{
 *         id: "foobar",
 *         filter: {
 *             prefix: "foo",
 *         },
 *         status: "Enabled",
 *         destination: {
 *             bucket: east.arn,
 *             storageClass: "STANDARD",
 *         },
 *     }],
 * }, {
 *     dependsOn: [westBucketVersioningV2],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ... other configuration ...
 * east = aws.s3.BucketV2("east", bucket="tf-test-bucket-east-12345")
 * east_bucket_versioning_v2 = aws.s3.BucketVersioningV2("east",
 *     bucket=east.id,
 *     versioning_configuration={
 *         "status": "Enabled",
 *     })
 * west = aws.s3.BucketV2("west", bucket="tf-test-bucket-west-12345")
 * west_bucket_versioning_v2 = aws.s3.BucketVersioningV2("west",
 *     bucket=west.id,
 *     versioning_configuration={
 *         "status": "Enabled",
 *     })
 * east_to_west = aws.s3.BucketReplicationConfig("east_to_west",
 *     role=east_replication["arn"],
 *     bucket=east.id,
 *     rules=[{
 *         "id": "foobar",
 *         "filter": {
 *             "prefix": "foo",
 *         },
 *         "status": "Enabled",
 *         "destination": {
 *             "bucket": west.arn,
 *             "storage_class": "STANDARD",
 *         },
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[east_bucket_versioning_v2]))
 * west_to_east = aws.s3.BucketReplicationConfig("west_to_east",
 *     role=west_replication["arn"],
 *     bucket=west.id,
 *     rules=[{
 *         "id": "foobar",
 *         "filter": {
 *             "prefix": "foo",
 *         },
 *         "status": "Enabled",
 *         "destination": {
 *             "bucket": east.arn,
 *             "storage_class": "STANDARD",
 *         },
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[west_bucket_versioning_v2]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ... other configuration ...
 *     var east = new Aws.S3.BucketV2("east", new()
 *     {
 *         Bucket = "tf-test-bucket-east-12345",
 *     });
 *     var eastBucketVersioningV2 = new Aws.S3.BucketVersioningV2("east", new()
 *     {
 *         Bucket = east.Id,
 *         VersioningConfiguration = new Aws.S3.Inputs.BucketVersioningV2VersioningConfigurationArgs
 *         {
 *             Status = "Enabled",
 *         },
 *     });
 *     var west = new Aws.S3.BucketV2("west", new()
 *     {
 *         Bucket = "tf-test-bucket-west-12345",
 *     });
 *     var westBucketVersioningV2 = new Aws.S3.BucketVersioningV2("west", new()
 *     {
 *         Bucket = west.Id,
 *         VersioningConfiguration = new Aws.S3.Inputs.BucketVersioningV2VersioningConfigurationArgs
 *         {
 *             Status = "Enabled",
 *         },
 *     });
 *     var eastToWest = new Aws.S3.BucketReplicationConfig("east_to_west", new()
 *     {
 *         Role = eastReplication.Arn,
 *         Bucket = east.Id,
 *         Rules = new[]
 *         {
 *             new Aws.S3.Inputs.BucketReplicationConfigRuleArgs
 *             {
 *                 Id = "foobar",
 *                 Filter = new Aws.S3.Inputs.BucketReplicationConfigRuleFilterArgs
 *                 {
 *                     Prefix = "foo",
 *                 },
 *                 Status = "Enabled",
 *                 Destination = new Aws.S3.Inputs.BucketReplicationConfigRuleDestinationArgs
 *                 {
 *                     Bucket = west.Arn,
 *                     StorageClass = "STANDARD",
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             eastBucketVersioningV2,
 *         },
 *     });
 *     var westToEast = new Aws.S3.BucketReplicationConfig("west_to_east", new()
 *     {
 *         Role = westReplication.Arn,
 *         Bucket = west.Id,
 *         Rules = new[]
 *         {
 *             new Aws.S3.Inputs.BucketReplicationConfigRuleArgs
 *             {
 *                 Id = "foobar",
 *                 Filter = new Aws.S3.Inputs.BucketReplicationConfigRuleFilterArgs
 *                 {
 *                     Prefix = "foo",
 *                 },
 *                 Status = "Enabled",
 *                 Destination = new Aws.S3.Inputs.BucketReplicationConfigRuleDestinationArgs
 *                 {
 *                     Bucket = east.Arn,
 *                     StorageClass = "STANDARD",
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             westBucketVersioningV2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ... other configuration ...
 * 		east, err := s3.NewBucketV2(ctx, "east", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket-east-12345"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		eastBucketVersioningV2, err := s3.NewBucketVersioningV2(ctx, "east", &s3.BucketVersioningV2Args{
 * 			Bucket: east.ID(),
 * 			VersioningConfiguration: &s3.BucketVersioningV2VersioningConfigurationArgs{
 * 				Status: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		west, err := s3.NewBucketV2(ctx, "west", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket-west-12345"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		westBucketVersioningV2, err := s3.NewBucketVersioningV2(ctx, "west", &s3.BucketVersioningV2Args{
 * 			Bucket: west.ID(),
 * 			VersioningConfiguration: &s3.BucketVersioningV2VersioningConfigurationArgs{
 * 				Status: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketReplicationConfig(ctx, "east_to_west", &s3.BucketReplicationConfigArgs{
 * 			Role:   pulumi.Any(eastReplication.Arn),
 * 			Bucket: east.ID(),
 * 			Rules: s3.BucketReplicationConfigRuleArray{
 * 				&s3.BucketReplicationConfigRuleArgs{
 * 					Id: pulumi.String("foobar"),
 * 					Filter: &s3.BucketReplicationConfigRuleFilterArgs{
 * 						Prefix: pulumi.String("foo"),
 * 					},
 * 					Status: pulumi.String("Enabled"),
 * 					Destination: &s3.BucketReplicationConfigRuleDestinationArgs{
 * 						Bucket:       west.Arn,
 * 						StorageClass: pulumi.String("STANDARD"),
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			eastBucketVersioningV2,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketReplicationConfig(ctx, "west_to_east", &s3.BucketReplicationConfigArgs{
 * 			Role:   pulumi.Any(westReplication.Arn),
 * 			Bucket: west.ID(),
 * 			Rules: s3.BucketReplicationConfigRuleArray{
 * 				&s3.BucketReplicationConfigRuleArgs{
 * 					Id: pulumi.String("foobar"),
 * 					Filter: &s3.BucketReplicationConfigRuleFilterArgs{
 * 						Prefix: pulumi.String("foo"),
 * 					},
 * 					Status: pulumi.String("Enabled"),
 * 					Destination: &s3.BucketReplicationConfigRuleDestinationArgs{
 * 						Bucket:       east.Arn,
 * 						StorageClass: pulumi.String("STANDARD"),
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			westBucketVersioningV2,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ... other configuration ...
 *         var east = new BucketV2("east", BucketV2Args.builder()
 *             .bucket("tf-test-bucket-east-12345")
 *             .build());
 *         var eastBucketVersioningV2 = new BucketVersioningV2("eastBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(east.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var west = new BucketV2("west", BucketV2Args.builder()
 *             .bucket("tf-test-bucket-west-12345")
 *             .build());
 *         var westBucketVersioningV2 = new BucketVersioningV2("westBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(west.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var eastToWest = new BucketReplicationConfig("eastToWest", BucketReplicationConfigArgs.builder()
 *             .role(eastReplication.arn())
 *             .bucket(east.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(west.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(eastBucketVersioningV2)
 *                 .build());
 *         var westToEast = new BucketReplicationConfig("westToEast", BucketReplicationConfigArgs.builder()
 *             .role(westReplication.arn())
 *             .bucket(west.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(east.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(westBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ... other configuration ...
 *   east:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test-bucket-east-12345
 *   eastBucketVersioningV2:
 *     type: aws:s3:BucketVersioningV2
 *     name: east
 *     properties:
 *       bucket: ${east.id}
 *       versioningConfiguration:
 *         status: Enabled
 *   west:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test-bucket-west-12345
 *   westBucketVersioningV2:
 *     type: aws:s3:BucketVersioningV2
 *     name: west
 *     properties:
 *       bucket: ${west.id}
 *       versioningConfiguration:
 *         status: Enabled
 *   eastToWest:
 *     type: aws:s3:BucketReplicationConfig
 *     name: east_to_west
 *     properties:
 *       role: ${eastReplication.arn}
 *       bucket: ${east.id}
 *       rules:
 *         - id: foobar
 *           filter:
 *             prefix: foo
 *           status: Enabled
 *           destination:
 *             bucket: ${west.arn}
 *             storageClass: STANDARD
 *     options:
 *       dependson:
 *         - ${eastBucketVersioningV2}
 *   westToEast:
 *     type: aws:s3:BucketReplicationConfig
 *     name: west_to_east
 *     properties:
 *       role: ${westReplication.arn}
 *       bucket: ${west.id}
 *       rules:
 *         - id: foobar
 *           filter:
 *             prefix: foo
 *           status: Enabled
 *           destination:
 *             bucket: ${east.arn}
 *             storageClass: STANDARD
 *     options:
 *       dependson:
 *         - ${westBucketVersioningV2}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket replication configuration using the `bucket`. For example:
 * ```sh
 * $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
 * ```
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public class BucketReplicationConfig internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketReplicationConfig,
) : KotlinCustomResource(javaResource, BucketReplicationConfigMapper) {
    /**
     * Name of the source S3 bucket you want Amazon S3 to monitor.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * List of configuration blocks describing the rules managing the replication. See below.
     */
    public val rules: Output<List<BucketReplicationConfigRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket's "Object Lock token".
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BucketReplicationConfigMapper : ResourceMapper<BucketReplicationConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketReplicationConfig::class == javaResource::class

    override fun map(javaResource: Resource): BucketReplicationConfig =
        BucketReplicationConfig(javaResource as com.pulumi.aws.s3.BucketReplicationConfig)
}

/**
 * @see [BucketReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketReplicationConfig].
 */
public suspend fun bucketReplicationConfig(
    name: String,
    block: suspend BucketReplicationConfigResourceBuilder.() -> Unit,
): BucketReplicationConfig {
    val builder = BucketReplicationConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketReplicationConfig(name: String): BucketReplicationConfig {
    val builder = BucketReplicationConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
