@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket request payment configuration resource. For more information, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html).
 * > **NOTE:** Destroying an `aws.s3.BucketRequestPaymentConfigurationV2` resource resets the bucket's `payer` to the S3 default: the bucket owner.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketRequestPaymentConfigurationV2("example", {
 *     bucket: exampleAwsS3Bucket.id,
 *     payer: "Requester",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketRequestPaymentConfigurationV2("example",
 *     bucket=example_aws_s3_bucket["id"],
 *     payer="Requester")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketRequestPaymentConfigurationV2("example", new()
 *     {
 *         Bucket = exampleAwsS3Bucket.Id,
 *         Payer = "Requester",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketRequestPaymentConfigurationV2(ctx, "example", &s3.BucketRequestPaymentConfigurationV2Args{
 * 			Bucket: pulumi.Any(exampleAwsS3Bucket.Id),
 * 			Payer:  pulumi.String("Requester"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2;
 * import com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketRequestPaymentConfigurationV2("example", BucketRequestPaymentConfigurationV2Args.builder()
 *             .bucket(exampleAwsS3Bucket.id())
 *             .payer("Requester")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketRequestPaymentConfigurationV2
 *     properties:
 *       bucket: ${exampleAwsS3Bucket.id}
 *       payer: Requester
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket request payment configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 * $ pulumi import aws:s3/bucketRequestPaymentConfigurationV2:BucketRequestPaymentConfigurationV2 example bucket-name
 * ```
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 * $ pulumi import aws:s3/bucketRequestPaymentConfigurationV2:BucketRequestPaymentConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property payer Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
 */
public data class BucketRequestPaymentConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val payer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args =
        com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .payer(payer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketRequestPaymentConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketRequestPaymentConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var payer: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("mtfykyebrvintcqy")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("pdajqirwqvsnnspw")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
     */
    @JvmName("aodvkkfaqyblfsui")
    public suspend fun payer(`value`: Output<String>) {
        this.payer = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("rgpsunpaqbxufany")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("hfwrgpoixrclomlv")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
     */
    @JvmName("brbetmiatqcghbmg")
    public suspend fun payer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payer = mapped
    }

    internal fun build(): BucketRequestPaymentConfigurationV2Args =
        BucketRequestPaymentConfigurationV2Args(
            bucket = bucket,
            expectedBucketOwner = expectedBucketOwner,
            payer = payer,
        )
}
