@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketV2CorsRule
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Grant
import com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRule
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Logging
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ObjectLockConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ServerSideEncryptionConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Versioning
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Website
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.s3.kotlin.outputs.BucketV2CorsRule.Companion.toKotlin as bucketV2CorsRuleToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Grant.Companion.toKotlin as bucketV2GrantToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRule.Companion.toKotlin as bucketV2LifecycleRuleToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Logging.Companion.toKotlin as bucketV2LoggingToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ObjectLockConfiguration.Companion.toKotlin as bucketV2ObjectLockConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfiguration.Companion.toKotlin as bucketV2ReplicationConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2ServerSideEncryptionConfiguration.Companion.toKotlin as bucketV2ServerSideEncryptionConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Versioning.Companion.toKotlin as bucketV2VersioningToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketV2Website.Companion.toKotlin as bucketV2WebsiteToKotlin

/**
 * Builder for [BucketV2].
 */
@PulumiTagMarker
public class BucketV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketV2Args = BucketV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketV2ArgsBuilder.() -> Unit) {
        val builder = BucketV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketV2 {
        val builtJavaResource = com.pulumi.aws.s3.BucketV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketV2(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket resource.
 * > This resource provides functionality for managing S3 general purpose buckets in an AWS Partition. To manage Amazon S3 Express directory buckets, use the `aws_directory_bucket` resource. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), use the `aws.s3control.Bucket` resource.
 * > Object Lock can be enabled by using the `object_lock_enable` attribute or by using the `aws.s3.BucketObjectLockConfigurationV2` resource. Please note, that by using the resource, Object Lock can be enabled/disabled without destroying and recreating the bucket.
 * ## Example Usage
 * ### Private Bucket With Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucket: "my-tf-test-bucket",
 *     tags: {
 *         Name: "My bucket",
 *         Environment: "Dev",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket="my-tf-test-bucket",
 *     tags={
 *         "Name": "My bucket",
 *         "Environment": "Dev",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-tf-test-bucket",
 *         Tags =
 *         {
 *             { "Name", "My bucket" },
 *             { "Environment", "Dev" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-test-bucket"),
 * 			Tags: pulumi.StringMap{
 * 				"Name":        pulumi.String("My bucket"),
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("my-tf-test-bucket")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "My bucket"),
 *                 Map.entry("Environment", "Dev")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-test-bucket
 *       tags:
 *         Name: My bucket
 *         Environment: Dev
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket using the `bucket`. For example:
 * ```sh
 * $ pulumi import aws:s3/bucketV2:BucketV2 bucket bucket-name
 * ```
 */
public class BucketV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketV2,
) : KotlinCustomResource(javaResource, BucketV2Mapper) {
    /**
     * Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketAccelerateConfigurationV2 resource instead
  """,
    )
    public val accelerationStatus: Output<String>
        get() = javaResource.accelerationStatus().applyValue({ args0 -> args0 })

    /**
     * The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketAclV2 resource instead
  """,
    )
    public val acl: Output<String>
        get() = javaResource.acl().applyValue({ args0 -> args0 })

    /**
     * ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
     */
    public val bucketDomainName: Output<String>
        get() = javaResource.bucketDomainName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    public val bucketPrefix: Output<String>
        get() = javaResource.bucketPrefix().applyValue({ args0 -> args0 })

    /**
     * The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/s3&#46;html#s3_region) for format&#46; Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin&#46; This will prevent redirect issues from CloudFront to the S3 Origin URL&#46; For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
     */
    public val bucketRegionalDomainName: Output<String>
        get() = javaResource.bucketRegionalDomainName().applyValue({ args0 -> args0 })

    /**
     * Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketCorsConfigurationV2 resource instead
  """,
    )
    public val corsRules: Output<List<BucketV2CorsRule>>
        get() = javaResource.corsRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2CorsRuleToKotlin(args0)
                })
            })
        })

    /**
     * Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketAclV2 resource instead
  """,
    )
    public val grants: Output<List<BucketV2Grant>>
        get() = javaResource.grants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2GrantToKotlin(args0)
                })
            })
        })

    /**
     * [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketLifecycleConfigurationV2 resource instead
  """,
    )
    public val lifecycleRules: Output<List<BucketV2LifecycleRule>>
        get() = javaResource.lifecycleRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketV2LifecycleRuleToKotlin(args0) })
            })
        })

    /**
     * Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketLoggingV2 resource instead
  """,
    )
    public val loggings: Output<List<BucketV2Logging>>
        get() = javaResource.loggings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2LoggingToKotlin(args0)
                })
            })
        })

    /**
     * Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled and the aws.s3.BucketObjectLockConfigurationV2
      resource instead
  """,
    )
    public val objectLockConfiguration: Output<BucketV2ObjectLockConfiguration>
        get() = javaResource.objectLockConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                bucketV2ObjectLockConfigurationToKotlin(args0)
            })
        })

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    public val objectLockEnabled: Output<Boolean>
        get() = javaResource.objectLockEnabled().applyValue({ args0 -> args0 })

    /**
     * Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketPolicy resource instead
  """,
    )
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * AWS region this bucket resides in.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketReplicationConfig resource instead
  """,
    )
    public val replicationConfigurations: Output<List<BucketV2ReplicationConfiguration>>
        get() = javaResource.replicationConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketV2ReplicationConfigurationToKotlin(args0) })
            })
        })

    /**
     * Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketRequestPaymentConfigurationV2 resource instead
  """,
    )
    public val requestPayer: Output<String>
        get() = javaResource.requestPayer().applyValue({ args0 -> args0 })

    /**
     * Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketServerSideEncryptionConfigurationV2 resource instead
  """,
    )
    public val serverSideEncryptionConfigurations:
        Output<List<BucketV2ServerSideEncryptionConfiguration>>
        get() = javaResource.serverSideEncryptionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2ServerSideEncryptionConfigurationToKotlin(args0)
                })
            })
        })

    /**
     * Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketVersioningV2 resource instead
  """,
    )
    public val versionings: Output<List<BucketV2Versioning>>
        get() = javaResource.versionings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2VersioningToKotlin(args0)
                })
            })
        })

    /**
     * (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketWebsiteConfigurationV2 resource
  """,
    )
    public val websiteDomain: Output<String>
        get() = javaResource.websiteDomain().applyValue({ args0 -> args0 })

    /**
     * (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketWebsiteConfigurationV2 resource
  """,
    )
    public val websiteEndpoint: Output<String>
        get() = javaResource.websiteEndpoint().applyValue({ args0 -> args0 })

    /**
     * Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws.s3.BucketWebsiteConfigurationV2 resource instead
  """,
    )
    public val websites: Output<List<BucketV2Website>>
        get() = javaResource.websites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketV2WebsiteToKotlin(args0)
                })
            })
        })
}

public object BucketV2Mapper : ResourceMapper<BucketV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketV2 = BucketV2(
        javaResource as
            com.pulumi.aws.s3.BucketV2,
    )
}

/**
 * @see [BucketV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketV2].
 */
public suspend fun bucketV2(name: String, block: suspend BucketV2ResourceBuilder.() -> Unit): BucketV2 {
    val builder = BucketV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketV2(name: String): BucketV2 {
    val builder = BucketV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
