@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.DirectoryBucketArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.DirectoryBucketLocationArgs
import com.pulumi.aws.s3.kotlin.inputs.DirectoryBucketLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon S3 Express directory bucket resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.DirectoryBucket("example", {
 *     bucket: "example--usw2-az1--x-s3",
 *     location: {
 *         name: "usw2-az1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.DirectoryBucket("example",
 *     bucket="example--usw2-az1--x-s3",
 *     location={
 *         "name": "usw2-az1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.DirectoryBucket("example", new()
 *     {
 *         Bucket = "example--usw2-az1--x-s3",
 *         Location = new Aws.S3.Inputs.DirectoryBucketLocationArgs
 *         {
 *             Name = "usw2-az1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewDirectoryBucket(ctx, "example", &s3.DirectoryBucketArgs{
 * 			Bucket: pulumi.String("example--usw2-az1--x-s3"),
 * 			Location: &s3.DirectoryBucketLocationArgs{
 * 				Name: pulumi.String("usw2-az1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.DirectoryBucket;
 * import com.pulumi.aws.s3.DirectoryBucketArgs;
 * import com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DirectoryBucket("example", DirectoryBucketArgs.builder()
 *             .bucket("example--usw2-az1--x-s3")
 *             .location(DirectoryBucketLocationArgs.builder()
 *                 .name("usw2-az1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:DirectoryBucket
 *     properties:
 *       bucket: example--usw2-az1--x-s3
 *       location:
 *         name: usw2-az1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket using `bucket`. For example:
 * ```sh
 * $ pulumi import aws:s3/directoryBucket:DirectoryBucket example example--usw2-az1--x-s3
 * ```
 * @property bucket Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.BucketV2` resource to manage general purpose buckets.
 * @property dataRedundancy Data redundancy. Valid values: `SingleAvailabilityZone`.
 * @property forceDestroy Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
 * @property location Bucket location. See Location below for more details.
 * @property type Bucket type. Valid values: `Directory`.
 */
public data class DirectoryBucketArgs(
    public val bucket: Output<String>? = null,
    public val dataRedundancy: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val location: Output<DirectoryBucketLocationArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.DirectoryBucketArgs> {
    override fun toJava(): com.pulumi.aws.s3.DirectoryBucketArgs =
        com.pulumi.aws.s3.DirectoryBucketArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .dataRedundancy(dataRedundancy?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryBucketArgs].
 */
@PulumiTagMarker
public class DirectoryBucketArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var dataRedundancy: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var location: Output<DirectoryBucketLocationArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.BucketV2` resource to manage general purpose buckets.
     */
    @JvmName("uhgeahmtkgcbxsat")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Data redundancy. Valid values: `SingleAvailabilityZone`.
     */
    @JvmName("ddpqlqcosxfhidrm")
    public suspend fun dataRedundancy(`value`: Output<String>) {
        this.dataRedundancy = value
    }

    /**
     * @param value Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("obvwrkeynvtkykha")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Bucket location. See Location below for more details.
     */
    @JvmName("apdnjjnphalkatvq")
    public suspend fun location(`value`: Output<DirectoryBucketLocationArgs>) {
        this.location = value
    }

    /**
     * @param value Bucket type. Valid values: `Directory`.
     */
    @JvmName("hbfbtavjuseolbrf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.BucketV2` resource to manage general purpose buckets.
     */
    @JvmName("oeefmjykqbtriviu")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Data redundancy. Valid values: `SingleAvailabilityZone`.
     */
    @JvmName("kuslwcnweffqiobh")
    public suspend fun dataRedundancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRedundancy = mapped
    }

    /**
     * @param value Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("cowbealanedowwsp")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Bucket location. See Location below for more details.
     */
    @JvmName("kkougcmuiviiklhm")
    public suspend fun location(`value`: DirectoryBucketLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument Bucket location. See Location below for more details.
     */
    @JvmName("wgwoxjgnewcskfmh")
    public suspend fun location(argument: suspend DirectoryBucketLocationArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryBucketLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value Bucket type. Valid values: `Directory`.
     */
    @JvmName("rsofyukdbupykqdw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DirectoryBucketArgs = DirectoryBucketArgs(
        bucket = bucket,
        dataRedundancy = dataRedundancy,
        forceDestroy = forceDestroy,
        location = location,
        type = type,
    )
}
