@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.InventoryDestination
import com.pulumi.aws.s3.kotlin.outputs.InventoryFilter
import com.pulumi.aws.s3.kotlin.outputs.InventorySchedule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.InventoryDestination.Companion.toKotlin as inventoryDestinationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.InventoryFilter.Companion.toKotlin as inventoryFilterToKotlin
import com.pulumi.aws.s3.kotlin.outputs.InventorySchedule.Companion.toKotlin as inventoryScheduleToKotlin

/**
 * Builder for [Inventory].
 */
@PulumiTagMarker
public class InventoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InventoryArgs = InventoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InventoryArgsBuilder.() -> Unit) {
        val builder = InventoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Inventory {
        val builtJavaResource = com.pulumi.aws.s3.Inventory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Inventory(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket [inventory configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add inventory configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.s3.BucketV2("test", {bucket: "my-tf-test-bucket"});
 * const inventory = new aws.s3.BucketV2("inventory", {bucket: "my-tf-inventory-bucket"});
 * const testInventory = new aws.s3.Inventory("test", {
 *     bucket: test.id,
 *     name: "EntireBucketDaily",
 *     includedObjectVersions: "All",
 *     schedule: {
 *         frequency: "Daily",
 *     },
 *     destination: {
 *         bucket: {
 *             format: "ORC",
 *             bucketArn: inventory.arn,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.s3.BucketV2("test", bucket="my-tf-test-bucket")
 * inventory = aws.s3.BucketV2("inventory", bucket="my-tf-inventory-bucket")
 * test_inventory = aws.s3.Inventory("test",
 *     bucket=test.id,
 *     name="EntireBucketDaily",
 *     included_object_versions="All",
 *     schedule={
 *         "frequency": "Daily",
 *     },
 *     destination={
 *         "bucket": {
 *             "format": "ORC",
 *             "bucket_arn": inventory.arn,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.S3.BucketV2("test", new()
 *     {
 *         Bucket = "my-tf-test-bucket",
 *     });
 *     var inventory = new Aws.S3.BucketV2("inventory", new()
 *     {
 *         Bucket = "my-tf-inventory-bucket",
 *     });
 *     var testInventory = new Aws.S3.Inventory("test", new()
 *     {
 *         Bucket = test.Id,
 *         Name = "EntireBucketDaily",
 *         IncludedObjectVersions = "All",
 *         Schedule = new Aws.S3.Inputs.InventoryScheduleArgs
 *         {
 *             Frequency = "Daily",
 *         },
 *         Destination = new Aws.S3.Inputs.InventoryDestinationArgs
 *         {
 *             Bucket = new Aws.S3.Inputs.InventoryDestinationBucketArgs
 *             {
 *                 Format = "ORC",
 *                 BucketArn = inventory.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := s3.NewBucketV2(ctx, "test", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-test-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		inventory, err := s3.NewBucketV2(ctx, "inventory", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-inventory-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewInventory(ctx, "test", &s3.InventoryArgs{
 * 			Bucket:                 test.ID(),
 * 			Name:                   pulumi.String("EntireBucketDaily"),
 * 			IncludedObjectVersions: pulumi.String("All"),
 * 			Schedule: &s3.InventoryScheduleArgs{
 * 				Frequency: pulumi.String("Daily"),
 * 			},
 * 			Destination: &s3.InventoryDestinationArgs{
 * 				Bucket: &s3.InventoryDestinationBucketArgs{
 * 					Format:    pulumi.String("ORC"),
 * 					BucketArn: inventory.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new BucketV2("test", BucketV2Args.builder()
 *             .bucket("my-tf-test-bucket")
 *             .build());
 *         var inventory = new BucketV2("inventory", BucketV2Args.builder()
 *             .bucket("my-tf-inventory-bucket")
 *             .build());
 *         var testInventory = new Inventory("testInventory", InventoryArgs.builder()
 *             .bucket(test.id())
 *             .name("EntireBucketDaily")
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-test-bucket
 *   inventory:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-inventory-bucket
 *   testInventory:
 *     type: aws:s3:Inventory
 *     name: test
 *     properties:
 *       bucket: ${test.id}
 *       name: EntireBucketDaily
 *       includedObjectVersions: All
 *       schedule:
 *         frequency: Daily
 *       destination:
 *         bucket:
 *           format: ORC
 *           bucketArn: ${inventory.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Add inventory configuration with S3 object prefix
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.s3.BucketV2("test", {bucket: "my-tf-test-bucket"});
 * const inventory = new aws.s3.BucketV2("inventory", {bucket: "my-tf-inventory-bucket"});
 * const test_prefix = new aws.s3.Inventory("test-prefix", {
 *     bucket: test.id,
 *     name: "DocumentsWeekly",
 *     includedObjectVersions: "All",
 *     schedule: {
 *         frequency: "Daily",
 *     },
 *     filter: {
 *         prefix: "documents/",
 *     },
 *     destination: {
 *         bucket: {
 *             format: "ORC",
 *             bucketArn: inventory.arn,
 *             prefix: "inventory",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.s3.BucketV2("test", bucket="my-tf-test-bucket")
 * inventory = aws.s3.BucketV2("inventory", bucket="my-tf-inventory-bucket")
 * test_prefix = aws.s3.Inventory("test-prefix",
 *     bucket=test.id,
 *     name="DocumentsWeekly",
 *     included_object_versions="All",
 *     schedule={
 *         "frequency": "Daily",
 *     },
 *     filter={
 *         "prefix": "documents/",
 *     },
 *     destination={
 *         "bucket": {
 *             "format": "ORC",
 *             "bucket_arn": inventory.arn,
 *             "prefix": "inventory",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.S3.BucketV2("test", new()
 *     {
 *         Bucket = "my-tf-test-bucket",
 *     });
 *     var inventory = new Aws.S3.BucketV2("inventory", new()
 *     {
 *         Bucket = "my-tf-inventory-bucket",
 *     });
 *     var test_prefix = new Aws.S3.Inventory("test-prefix", new()
 *     {
 *         Bucket = test.Id,
 *         Name = "DocumentsWeekly",
 *         IncludedObjectVersions = "All",
 *         Schedule = new Aws.S3.Inputs.InventoryScheduleArgs
 *         {
 *             Frequency = "Daily",
 *         },
 *         Filter = new Aws.S3.Inputs.InventoryFilterArgs
 *         {
 *             Prefix = "documents/",
 *         },
 *         Destination = new Aws.S3.Inputs.InventoryDestinationArgs
 *         {
 *             Bucket = new Aws.S3.Inputs.InventoryDestinationBucketArgs
 *             {
 *                 Format = "ORC",
 *                 BucketArn = inventory.Arn,
 *                 Prefix = "inventory",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := s3.NewBucketV2(ctx, "test", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-test-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		inventory, err := s3.NewBucketV2(ctx, "inventory", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-tf-inventory-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewInventory(ctx, "test-prefix", &s3.InventoryArgs{
 * 			Bucket:                 test.ID(),
 * 			Name:                   pulumi.String("DocumentsWeekly"),
 * 			IncludedObjectVersions: pulumi.String("All"),
 * 			Schedule: &s3.InventoryScheduleArgs{
 * 				Frequency: pulumi.String("Daily"),
 * 			},
 * 			Filter: &s3.InventoryFilterArgs{
 * 				Prefix: pulumi.String("documents/"),
 * 			},
 * 			Destination: &s3.InventoryDestinationArgs{
 * 				Bucket: &s3.InventoryDestinationBucketArgs{
 * 					Format:    pulumi.String("ORC"),
 * 					BucketArn: inventory.Arn,
 * 					Prefix:    pulumi.String("inventory"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryFilterArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new BucketV2("test", BucketV2Args.builder()
 *             .bucket("my-tf-test-bucket")
 *             .build());
 *         var inventory = new BucketV2("inventory", BucketV2Args.builder()
 *             .bucket("my-tf-inventory-bucket")
 *             .build());
 *         var test_prefix = new Inventory("test-prefix", InventoryArgs.builder()
 *             .bucket(test.id())
 *             .name("DocumentsWeekly")
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .filter(InventoryFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .prefix("inventory")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-test-bucket
 *   inventory:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-tf-inventory-bucket
 *   test-prefix:
 *     type: aws:s3:Inventory
 *     properties:
 *       bucket: ${test.id}
 *       name: DocumentsWeekly
 *       includedObjectVersions: All
 *       schedule:
 *         frequency: Daily
 *       filter:
 *         prefix: documents/
 *       destination:
 *         bucket:
 *           format: ORC
 *           bucketArn: ${inventory.arn}
 *           prefix: inventory
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 bucket inventory configurations using `bucket:inventory`. For example:
 * ```sh
 * $ pulumi import aws:s3/inventory:Inventory my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 */
public class Inventory internal constructor(
    override val javaResource: com.pulumi.aws.s3.Inventory,
) : KotlinCustomResource(javaResource, InventoryMapper) {
    /**
     * Name of the source bucket that inventory lists the objects for.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Contains information about where to publish the inventory results (documented below).
     */
    public val destination: Output<InventoryDestination>
        get() = javaResource.destination().applyValue({ args0 ->
            args0.let({ args0 ->
                inventoryDestinationToKotlin(args0)
            })
        })

    /**
     * Specifies whether the inventory is enabled or disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
     */
    public val filter: Output<InventoryFilter>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    inventoryFilterToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Object versions to include in the inventory list. Valid values: `All`, `Current`.
     */
    public val includedObjectVersions: Output<String>
        get() = javaResource.includedObjectVersions().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the inventory configuration for the bucket.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    public val optionalFields: Output<List<String>>?
        get() = javaResource.optionalFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies the schedule for generating inventory results (documented below).
     */
    public val schedule: Output<InventorySchedule>
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.let({ args0 ->
                inventoryScheduleToKotlin(args0)
            })
        })
}

public object InventoryMapper : ResourceMapper<Inventory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.Inventory::class == javaResource::class

    override fun map(javaResource: Resource): Inventory = Inventory(
        javaResource as
            com.pulumi.aws.s3.Inventory,
    )
}

/**
 * @see [Inventory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Inventory].
 */
public suspend fun inventory(name: String, block: suspend InventoryResourceBuilder.() -> Unit): Inventory {
    val builder = InventoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Inventory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inventory(name: String): Inventory {
    val builder = InventoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
