@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.ObjectCopyGrant
import com.pulumi.aws.s3.kotlin.outputs.ObjectCopyGrant.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ObjectCopy].
 */
@PulumiTagMarker
public class ObjectCopyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObjectCopyArgs = ObjectCopyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObjectCopyArgsBuilder.() -> Unit) {
        val builder = ObjectCopyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ObjectCopy {
        val builtJavaResource = com.pulumi.aws.s3.ObjectCopy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ObjectCopy(builtJavaResource)
    }
}

/**
 * Provides a resource for copying an S3 object.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.s3.ObjectCopy("test", {
 *     bucket: "destination_bucket",
 *     key: "destination_key",
 *     source: "source_bucket/source_key",
 *     grants: [{
 *         uri: "http://acs.amazonaws.com/groups/global/AllUsers",
 *         type: "Group",
 *         permissions: ["READ"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.s3.ObjectCopy("test",
 *     bucket="destination_bucket",
 *     key="destination_key",
 *     source="source_bucket/source_key",
 *     grants=[{
 *         "uri": "http://acs.amazonaws.com/groups/global/AllUsers",
 *         "type": "Group",
 *         "permissions": ["READ"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.S3.ObjectCopy("test", new()
 *     {
 *         Bucket = "destination_bucket",
 *         Key = "destination_key",
 *         Source = "source_bucket/source_key",
 *         Grants = new[]
 *         {
 *             new Aws.S3.Inputs.ObjectCopyGrantArgs
 *             {
 *                 Uri = "http://acs.amazonaws.com/groups/global/AllUsers",
 *                 Type = "Group",
 *                 Permissions = new[]
 *                 {
 *                     "READ",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewObjectCopy(ctx, "test", &s3.ObjectCopyArgs{
 * 			Bucket: pulumi.String("destination_bucket"),
 * 			Key:    pulumi.String("destination_key"),
 * 			Source: pulumi.String("source_bucket/source_key"),
 * 			Grants: s3.ObjectCopyGrantArray{
 * 				&s3.ObjectCopyGrantArgs{
 * 					Uri:  pulumi.String("http://acs.amazonaws.com/groups/global/AllUsers"),
 * 					Type: pulumi.String("Group"),
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("READ"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.ObjectCopy;
 * import com.pulumi.aws.s3.ObjectCopyArgs;
 * import com.pulumi.aws.s3.inputs.ObjectCopyGrantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ObjectCopy("test", ObjectCopyArgs.builder()
 *             .bucket("destination_bucket")
 *             .key("destination_key")
 *             .source("source_bucket/source_key")
 *             .grants(ObjectCopyGrantArgs.builder()
 *                 .uri("http://acs.amazonaws.com/groups/global/AllUsers")
 *                 .type("Group")
 *                 .permissions("READ")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:s3:ObjectCopy
 *     properties:
 *       bucket: destination_bucket
 *       key: destination_key
 *       source: source_bucket/source_key
 *       grants:
 *         - uri: http://acs.amazonaws.com/groups/global/AllUsers
 *           type: Group
 *           permissions:
 *             - READ
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ObjectCopy internal constructor(
    override val javaResource: com.pulumi.aws.s3.ObjectCopy,
) : KotlinCustomResource(javaResource, ObjectCopyMapper) {
    /**
     * [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
     */
    public val acl: Output<String>
        get() = javaResource.acl().applyValue({ args0 -> args0 })

    /**
     * ARN of the object.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the bucket to put the file in.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    public val bucketKeyEnabled: Output<Boolean>
        get() = javaResource.bucketKeyEnabled().applyValue({ args0 -> args0 })

    /**
     * Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
     */
    public val cacheControl: Output<String>
        get() = javaResource.cacheControl().applyValue({ args0 -> args0 })

    /**
     * Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `SHA1`, `SHA256`.
     */
    public val checksumAlgorithm: Output<String>?
        get() = javaResource.checksumAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The base64-encoded, 32-bit CRC32 checksum of the object.
     */
    public val checksumCrc32: Output<String>
        get() = javaResource.checksumCrc32().applyValue({ args0 -> args0 })

    /**
     * The base64-encoded, 32-bit CRC32C checksum of the object.
     */
    public val checksumCrc32c: Output<String>
        get() = javaResource.checksumCrc32c().applyValue({ args0 -> args0 })

    /**
     * The base64-encoded, 160-bit SHA-1 digest of the object.
     */
    public val checksumSha1: Output<String>
        get() = javaResource.checksumSha1().applyValue({ args0 -> args0 })

    /**
     * The base64-encoded, 256-bit SHA-256 digest of the object.
     */
    public val checksumSha256: Output<String>
        get() = javaResource.checksumSha256().applyValue({ args0 -> args0 })

    /**
     * Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
     */
    public val contentDisposition: Output<String>
        get() = javaResource.contentDisposition().applyValue({ args0 -> args0 })

    /**
     * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
     */
    public val contentEncoding: Output<String>
        get() = javaResource.contentEncoding().applyValue({ args0 -> args0 })

    /**
     * Language the content is in e.g., en-US or en-GB.
     */
    public val contentLanguage: Output<String>
        get() = javaResource.contentLanguage().applyValue({ args0 -> args0 })

    /**
     * Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Copies the object if its entity tag (ETag) matches the specified tag.
     */
    public val copyIfMatch: Output<String>?
        get() = javaResource.copyIfMatch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val copyIfModifiedSince: Output<String>?
        get() = javaResource.copyIfModifiedSince().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Copies the object if its entity tag (ETag) is different than the specified ETag.
     */
    public val copyIfNoneMatch: Output<String>?
        get() = javaResource.copyIfNoneMatch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val copyIfUnmodifiedSince: Output<String>?
        get() = javaResource.copyIfUnmodifiedSince().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the algorithm to use to when encrypting the object (for example, AES256).
     */
    public val customerAlgorithm: Output<String>
        get() = javaResource.customerAlgorithm().applyValue({ args0 -> args0 })

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
     */
    public val customerKey: Output<String>?
        get() = javaResource.customerKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     */
    public val customerKeyMd5: Output<String>
        get() = javaResource.customerKeyMd5().applyValue({ args0 -> args0 })

    /**
     * ETag generated for the object (an MD5 sum of the object content). For plaintext objects or objects encrypted with an AWS-managed key, the hash is an MD5 digest of the object data. For objects encrypted with a KMS key or objects created by either the Multipart Upload or Part Copy operation, the hash is not an MD5 digest, regardless of the method of encryption. More information on possible values can be found on [Common Response Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonResponseHeaders.html).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
     */
    public val expectedSourceBucketOwner: Output<String>?
        get() = javaResource.expectedSourceBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the object expiration is configured, this attribute will be set.
     */
    public val expiration: Output<String>
        get() = javaResource.expiration().applyValue({ args0 -> args0 })

    /**
     * Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val expires: Output<String>?
        get() = javaResource.expires().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for header grants. Documented below. Conflicts with `acl`.
     */
    public val grants: Output<List<ObjectCopyGrant>>?
        get() = javaResource.grants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Name of the object once it is in the bucket.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
     */
    public val kmsEncryptionContext: Output<String>
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 -> args0 })

    /**
     * Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `aws.kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Returns the date that the object was last modified, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
     */
    public val metadata: Output<Map<String, String>>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
     */
    public val metadataDirective: Output<String>?
        get() = javaResource.metadataDirective().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
     */
    public val objectLockLegalHoldStatus: Output<String>
        get() = javaResource.objectLockLegalHoldStatus().applyValue({ args0 -> args0 })

    /**
     * Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    public val objectLockMode: Output<String>
        get() = javaResource.objectLockMode().applyValue({ args0 -> args0 })

    /**
     * Date and time, in [RFC3339 format](https://tools&#46;ietf&#46;org/html/rfc3339#section-5&#46;8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
     */
    public val objectLockRetainUntilDate: Output<String>
        get() = javaResource.objectLockRetainUntilDate().applyValue({ args0 -> args0 })

    /**
     * If present, indicates that the requester was successfully charged for the request.
     */
    public val requestCharged: Output<Boolean>
        get() = javaResource.requestCharged().applyValue({ args0 -> args0 })

    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
     */
    public val requestPayer: Output<String>?
        get() = javaResource.requestPayer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
     */
    public val serverSideEncryption: Output<String>
        get() = javaResource.serverSideEncryption().applyValue({ args0 -> args0 })

    /**
     * Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the ARN of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
     * The following arguments are optional:
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * Specifies the algorithm to use when decrypting the source object (for example, AES256).
     */
    public val sourceCustomerAlgorithm: Output<String>?
        get() = javaResource.sourceCustomerAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
     */
    public val sourceCustomerKey: Output<String>?
        get() = javaResource.sourceCustomerKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     */
    public val sourceCustomerKeyMd5: Output<String>?
        get() = javaResource.sourceCustomerKeyMd5().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version of the copied object in the source bucket.
     */
    public val sourceVersionId: Output<String>
        get() = javaResource.sourceVersionId().applyValue({ args0 -> args0 })

    /**
     * Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
     */
    public val storageClass: Output<String>
        get() = javaResource.storageClass().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
     */
    public val taggingDirective: Output<String>?
        get() = javaResource.taggingDirective().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Version ID of the newly created copy.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })

    /**
     * Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
     */
    public val websiteRedirect: Output<String>
        get() = javaResource.websiteRedirect().applyValue({ args0 -> args0 })
}

public object ObjectCopyMapper : ResourceMapper<ObjectCopy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.ObjectCopy::class == javaResource::class

    override fun map(javaResource: Resource): ObjectCopy = ObjectCopy(
        javaResource as
            com.pulumi.aws.s3.ObjectCopy,
    )
}

/**
 * @see [ObjectCopy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObjectCopy].
 */
public suspend fun objectCopy(name: String, block: suspend ObjectCopyResourceBuilder.() -> Unit): ObjectCopy {
    val builder = ObjectCopyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObjectCopy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun objectCopy(name: String): ObjectCopy {
    val builder = ObjectCopyResourceBuilder()
    builder.name(name)
    return builder.build()
}
