@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.S3Functions.getAccountPublicAccessBlockPlain
import com.pulumi.aws.s3.S3Functions.getBucketObjectPlain
import com.pulumi.aws.s3.S3Functions.getBucketObjectsPlain
import com.pulumi.aws.s3.S3Functions.getBucketPlain
import com.pulumi.aws.s3.S3Functions.getBucketPolicyPlain
import com.pulumi.aws.s3.S3Functions.getCanonicalUserIdPlain
import com.pulumi.aws.s3.S3Functions.getDirectoryBucketsPlain
import com.pulumi.aws.s3.S3Functions.getObjectPlain
import com.pulumi.aws.s3.S3Functions.getObjectsPlain
import com.pulumi.aws.s3.kotlin.inputs.GetAccountPublicAccessBlockPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetAccountPublicAccessBlockPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectsPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectsPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPolicyPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPolicyPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetObjectPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetObjectPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetObjectsPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetObjectsPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.outputs.GetAccountPublicAccessBlockResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectsResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketPolicyResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketResult
import com.pulumi.aws.s3.kotlin.outputs.GetCanonicalUserIdResult
import com.pulumi.aws.s3.kotlin.outputs.GetDirectoryBucketsResult
import com.pulumi.aws.s3.kotlin.outputs.GetObjectResult
import com.pulumi.aws.s3.kotlin.outputs.GetObjectsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.s3.kotlin.outputs.GetAccountPublicAccessBlockResult.Companion.toKotlin as getAccountPublicAccessBlockResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectResult.Companion.toKotlin as getBucketObjectResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectsResult.Companion.toKotlin as getBucketObjectsResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketPolicyResult.Companion.toKotlin as getBucketPolicyResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketResult.Companion.toKotlin as getBucketResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetCanonicalUserIdResult.Companion.toKotlin as getCanonicalUserIdResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetDirectoryBucketsResult.Companion.toKotlin as getDirectoryBucketsResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetObjectResult.Companion.toKotlin as getObjectResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetObjectsResult.Companion.toKotlin as getObjectsResultToKotlin

public object S3Functions {
    /**
     * The S3 account public access block data source returns account-level public access block configuration.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.s3.getAccountPublicAccessBlock({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.s3.get_account_public_access_block()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.S3.GetAccountPublicAccessBlock.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := s3.LookupAccountPublicAccessBlock(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getAccountPublicAccessBlock();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:s3:getAccountPublicAccessBlock
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccountPublicAccessBlock.
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend fun getAccountPublicAccessBlock(argument: GetAccountPublicAccessBlockPlainArgs): GetAccountPublicAccessBlockResult =
        getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(argument.toJava()).await())

    /**
     * @see [getAccountPublicAccessBlock].
     * @param accountId AWS account ID to configure. Defaults to automatically determined account ID of the AWS provider.
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend fun getAccountPublicAccessBlock(accountId: String? = null): GetAccountPublicAccessBlockResult {
        val argument = GetAccountPublicAccessBlockPlainArgs(
            accountId = accountId,
        )
        return getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountPublicAccessBlock].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetAccountPublicAccessBlockPlainArgs].
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend fun getAccountPublicAccessBlock(argument: suspend GetAccountPublicAccessBlockPlainArgsBuilder.() -> Unit): GetAccountPublicAccessBlockResult {
        val builder = GetAccountPublicAccessBlockPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific S3 bucket.
     * This resource may prove useful when setting up a Route53 record, or an origin for a CloudFront
     * Distribution.
     * ## Example Usage
     * ### Route53 Record
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.s3.getBucket({
     *     bucket: "bucket.test.com",
     * });
     * const testZone = aws.route53.getZone({
     *     name: "test.com.",
     * });
     * const example = new aws.route53.Record("example", {
     *     zoneId: testZone.then(testZone => testZone.id),
     *     name: "bucket",
     *     type: aws.route53.RecordType.A,
     *     aliases: [{
     *         name: selected.then(selected => selected.websiteDomain),
     *         zoneId: selected.then(selected => selected.hostedZoneId),
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.s3.get_bucket(bucket="bucket.test.com")
     * test_zone = aws.route53.get_zone(name="test.com.")
     * example = aws.route53.Record("example",
     *     zone_id=test_zone.id,
     *     name="bucket",
     *     type=aws.route53.RecordType.A,
     *     aliases=[{
     *         "name": selected.website_domain,
     *         "zone_id": selected.hosted_zone_id,
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.S3.GetBucket.Invoke(new()
     *     {
     *         Bucket = "bucket.test.com",
     *     });
     *     var testZone = Aws.Route53.GetZone.Invoke(new()
     *     {
     *         Name = "test.com.",
     *     });
     *     var example = new Aws.Route53.Record("example", new()
     *     {
     *         ZoneId = testZone.Apply(getZoneResult => getZoneResult.Id),
     *         Name = "bucket",
     *         Type = Aws.Route53.RecordType.A,
     *         Aliases = new[]
     *         {
     *             new Aws.Route53.Inputs.RecordAliasArgs
     *             {
     *                 Name = selected.Apply(getBucketResult => getBucketResult.WebsiteDomain),
     *                 ZoneId = selected.Apply(getBucketResult => getBucketResult.HostedZoneId),
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		selected, err := s3.LookupBucket(ctx, &s3.LookupBucketArgs{
     * 			Bucket: "bucket.test.com",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		testZone, err := route53.LookupZone(ctx, &route53.LookupZoneArgs{
     * 			Name: pulumi.StringRef("test.com."),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = route53.NewRecord(ctx, "example", &route53.RecordArgs{
     * 			ZoneId: pulumi.String(testZone.Id),
     * 			Name:   pulumi.String("bucket"),
     * 			Type:   pulumi.String(route53.RecordTypeA),
     * 			Aliases: route53.RecordAliasArray{
     * 				&route53.RecordAliasArgs{
     * 					Name:   pulumi.String(selected.WebsiteDomain),
     * 					ZoneId: pulumi.String(selected.HostedZoneId),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketArgs;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetZoneArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = S3Functions.getBucket(GetBucketArgs.builder()
     *             .bucket("bucket.test.com")
     *             .build());
     *         final var testZone = Route53Functions.getZone(GetZoneArgs.builder()
     *             .name("test.com.")
     *             .build());
     *         var example = new Record("example", RecordArgs.builder()
     *             .zoneId(testZone.applyValue(getZoneResult -> getZoneResult.id()))
     *             .name("bucket")
     *             .type("A")
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(selected.applyValue(getBucketResult -> getBucketResult.websiteDomain()))
     *                 .zoneId(selected.applyValue(getBucketResult -> getBucketResult.hostedZoneId()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:route53:Record
     *     properties:
     *       zoneId: ${testZone.id}
     *       name: bucket
     *       type: A
     *       aliases:
     *         - name: ${selected.websiteDomain}
     *           zoneId: ${selected.hostedZoneId}
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:s3:getBucket
     *       Arguments:
     *         bucket: bucket.test.com
     *   testZone:
     *     fn::invoke:
     *       Function: aws:route53:getZone
     *       Arguments:
     *         name: test.com.
     * ```
     * <!--End PulumiCodeChooser -->
     * ### CloudFront Origin
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.s3.getBucket({
     *     bucket: "a-test-bucket",
     * });
     * const test = new aws.cloudfront.Distribution("test", {origins: [{
     *     domainName: selected.then(selected => selected.bucketDomainName),
     *     originId: "s3-selected-bucket",
     * }]});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.s3.get_bucket(bucket="a-test-bucket")
     * test = aws.cloudfront.Distribution("test", origins=[{
     *     "domain_name": selected.bucket_domain_name,
     *     "origin_id": "s3-selected-bucket",
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.S3.GetBucket.Invoke(new()
     *     {
     *         Bucket = "a-test-bucket",
     *     });
     *     var test = new Aws.CloudFront.Distribution("test", new()
     *     {
     *         Origins = new[]
     *         {
     *             new Aws.CloudFront.Inputs.DistributionOriginArgs
     *             {
     *                 DomainName = selected.Apply(getBucketResult => getBucketResult.BucketDomainName),
     *                 OriginId = "s3-selected-bucket",
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		selected, err := s3.LookupBucket(ctx, &s3.LookupBucketArgs{
     * 			Bucket: "a-test-bucket",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = cloudfront.NewDistribution(ctx, "test", &cloudfront.DistributionArgs{
     * 			Origins: cloudfront.DistributionOriginArray{
     * 				&cloudfront.DistributionOriginArgs{
     * 					DomainName: pulumi.String(selected.BucketDomainName),
     * 					OriginId:   pulumi.String("s3-selected-bucket"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketArgs;
     * import com.pulumi.aws.cloudfront.Distribution;
     * import com.pulumi.aws.cloudfront.DistributionArgs;
     * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = S3Functions.getBucket(GetBucketArgs.builder()
     *             .bucket("a-test-bucket")
     *             .build());
     *         var test = new Distribution("test", DistributionArgs.builder()
     *             .origins(DistributionOriginArgs.builder()
     *                 .domainName(selected.applyValue(getBucketResult -> getBucketResult.bucketDomainName()))
     *                 .originId("s3-selected-bucket")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   test:
     *     type: aws:cloudfront:Distribution
     *     properties:
     *       origins:
     *         - domainName: ${selected.bucketDomainName}
     *           originId: s3-selected-bucket
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:s3:getBucket
     *       Arguments:
     *         bucket: a-test-bucket
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBucket.
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(argument: GetBucketPlainArgs): GetBucketResult =
        getBucketResultToKotlin(getBucketPlain(argument.toJava()).await())

    /**
     * @see [getBucket].
     * @param bucket Name of the bucket
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(bucket: String): GetBucketResult {
        val argument = GetBucketPlainArgs(
            bucket = bucket,
        )
        return getBucketResultToKotlin(getBucketPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucket].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketPlainArgs].
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(argument: suspend GetBucketPlainArgsBuilder.() -> Unit): GetBucketResult {
        val builder = GetBucketPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketResultToKotlin(getBucketPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** The `aws.s3.BucketObject` data source is DEPRECATED and will be removed in a future version! Use `aws.s3.BucketObjectv2` instead, where new features and fixes will be added.
     * The S3 object data source allows access to the metadata and
     * _optionally_ (see below) content of an object stored inside S3 bucket.
     * > **Note:** The content of an object (`body` field) is available only for objects which have a human-readable `Content-Type`:
     * * `text/*`
     * * `application/json`
     * * `application/ld+json`
     * * `application/x-httpd-php`
     * * `application/xhtml+xml`
     * * `application/x-csh`
     * * `application/x-sh`
     * * `application/xml`
     * * `application/atom+xml`
     * * `application/x-sql`
     * This is to prevent printing unsafe characters and potentially downloading large amount of data which would be thrown away in favor of metadata.
     * ## Example Usage
     * The following example retrieves a text object (which must have a `Content-Type`
     * value starting with `text/`) and uses it as the `user_data` for an EC2 instance:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const bootstrapScript = aws.s3.getBucketObject({
     *     bucket: "ourcorp-deploy-config",
     *     key: "ec2-bootstrap-script.sh",
     * });
     * const example = new aws.ec2.Instance("example", {
     *     instanceType: aws.ec2.InstanceType.T2_Micro,
     *     ami: "ami-2757f631",
     *     userData: bootstrapScript.then(bootstrapScript => bootstrapScript.body),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * bootstrap_script = aws.s3.get_bucket_object(bucket="ourcorp-deploy-config",
     *     key="ec2-bootstrap-script.sh")
     * example = aws.ec2.Instance("example",
     *     instance_type=aws.ec2.InstanceType.T2_MICRO,
     *     ami="ami-2757f631",
     *     user_data=bootstrap_script.body)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bootstrapScript = Aws.S3.GetBucketObject.Invoke(new()
     *     {
     *         Bucket = "ourcorp-deploy-config",
     *         Key = "ec2-bootstrap-script.sh",
     *     });
     *     var example = new Aws.Ec2.Instance("example", new()
     *     {
     *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
     *         Ami = "ami-2757f631",
     *         UserData = bootstrapScript.Apply(getBucketObjectResult => getBucketObjectResult.Body),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		bootstrapScript, err := s3.LookupBucketObject(ctx, &s3.LookupBucketObjectArgs{
     * 			Bucket: "ourcorp-deploy-config",
     * 			Key:    "ec2-bootstrap-script.sh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "example", &ec2.InstanceArgs{
     * 			InstanceType: pulumi.String(ec2.InstanceType_T2_Micro),
     * 			Ami:          pulumi.String("ami-2757f631"),
     * 			UserData:     pulumi.String(bootstrapScript.Body),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketObjectArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bootstrapScript = S3Functions.getBucketObject(GetBucketObjectArgs.builder()
     *             .bucket("ourcorp-deploy-config")
     *             .key("ec2-bootstrap-script.sh")
     *             .build());
     *         var example = new Instance("example", InstanceArgs.builder()
     *             .instanceType("t2.micro")
     *             .ami("ami-2757f631")
     *             .userData(bootstrapScript.applyValue(getBucketObjectResult -> getBucketObjectResult.body()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:ec2:Instance
     *     properties:
     *       instanceType: t2.micro
     *       ami: ami-2757f631
     *       userData: ${bootstrapScript.body}
     * variables:
     *   bootstrapScript:
     *     fn::invoke:
     *       Function: aws:s3:getBucketObject
     *       Arguments:
     *         bucket: ourcorp-deploy-config
     *         key: ec2-bootstrap-script.sh
     * ```
     * <!--End PulumiCodeChooser -->
     * The following, more-complex example retrieves only the metadata for a zip
     * file stored in S3, which is then used to pass the most recent `version_id`
     * to AWS Lambda for use as a function implementation. More information about
     * Lambda functions is available in the documentation for
     * `aws.lambda.Function`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const lambda = aws.s3.getBucketObject({
     *     bucket: "ourcorp-lambda-functions",
     *     key: "hello-world.zip",
     * });
     * const testLambda = new aws.lambda.Function("test_lambda", {
     *     s3Bucket: lambda.then(lambda => lambda.id),
     *     s3Key: lambda.then(lambda => lambda.key),
     *     s3ObjectVersion: lambda.then(lambda => lambda.versionId),
     *     name: "lambda_function_name",
     *     role: iamForLambda.arn,
     *     handler: "exports.test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * lambda_ = aws.s3.get_bucket_object(bucket="ourcorp-lambda-functions",
     *     key="hello-world.zip")
     * test_lambda = aws.lambda_.Function("test_lambda",
     *     s3_bucket=lambda_.id,
     *     s3_key=lambda_.key,
     *     s3_object_version=lambda_.version_id,
     *     name="lambda_function_name",
     *     role=iam_for_lambda["arn"],
     *     handler="exports.test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var lambda = Aws.S3.GetBucketObject.Invoke(new()
     *     {
     *         Bucket = "ourcorp-lambda-functions",
     *         Key = "hello-world.zip",
     *     });
     *     var testLambda = new Aws.Lambda.Function("test_lambda", new()
     *     {
     *         S3Bucket = lambda.Apply(getBucketObjectResult => getBucketObjectResult.Id),
     *         S3Key = lambda.Apply(getBucketObjectResult => getBucketObjectResult.Key),
     *         S3ObjectVersion = lambda.Apply(getBucketObjectResult => getBucketObjectResult.VersionId),
     *         Name = "lambda_function_name",
     *         Role = iamForLambda.Arn,
     *         Handler = "exports.test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		lambda, err := s3.LookupBucketObject(ctx, &s3.LookupBucketObjectArgs{
     * 			Bucket: "ourcorp-lambda-functions",
     * 			Key:    "hello-world.zip",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = lambda.NewFunction(ctx, "test_lambda", &lambda.FunctionArgs{
     * 			S3Bucket:        pulumi.String(lambda.Id),
     * 			S3Key:           pulumi.String(lambda.Key),
     * 			S3ObjectVersion: pulumi.String(lambda.VersionId),
     * 			Name:            pulumi.String("lambda_function_name"),
     * 			Role:            pulumi.Any(iamForLambda.Arn),
     * 			Handler:         pulumi.String("exports.test"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketObjectArgs;
     * import com.pulumi.aws.lambda.Function;
     * import com.pulumi.aws.lambda.FunctionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var lambda = S3Functions.getBucketObject(GetBucketObjectArgs.builder()
     *             .bucket("ourcorp-lambda-functions")
     *             .key("hello-world.zip")
     *             .build());
     *         var testLambda = new Function("testLambda", FunctionArgs.builder()
     *             .s3Bucket(lambda.applyValue(getBucketObjectResult -> getBucketObjectResult.id()))
     *             .s3Key(lambda.applyValue(getBucketObjectResult -> getBucketObjectResult.key()))
     *             .s3ObjectVersion(lambda.applyValue(getBucketObjectResult -> getBucketObjectResult.versionId()))
     *             .name("lambda_function_name")
     *             .role(iamForLambda.arn())
     *             .handler("exports.test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testLambda:
     *     type: aws:lambda:Function
     *     name: test_lambda
     *     properties:
     *       s3Bucket: ${lambda.id}
     *       s3Key: ${lambda.key}
     *       s3ObjectVersion: ${lambda.versionId}
     *       name: lambda_function_name
     *       role: ${iamForLambda.arn}
     *       handler: exports.test
     * variables:
     *   lambda:
     *     fn::invoke:
     *       Function: aws:s3:getBucketObject
     *       Arguments:
     *         bucket: ourcorp-lambda-functions
     *         key: hello-world.zip
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBucketObject.
     * @return A collection of values returned by getBucketObject.
     * */
     */
    public suspend fun getBucketObject(argument: GetBucketObjectPlainArgs): GetBucketObjectResult =
        getBucketObjectResultToKotlin(getBucketObjectPlain(argument.toJava()).await())

    /**
     * @see [getBucketObject].
     * @param bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param key Full path to the object inside the bucket
     * @param range
     * @param tags Map of tags assigned to the object.
     * @param versionId Specific version ID of the object returned (defaults to latest version)
     * @return A collection of values returned by getBucketObject.
     */
    public suspend fun getBucketObject(
        bucket: String,
        key: String,
        range: String? = null,
        tags: Map<String, String>? = null,
        versionId: String? = null,
    ): GetBucketObjectResult {
        val argument = GetBucketObjectPlainArgs(
            bucket = bucket,
            key = key,
            range = range,
            tags = tags,
            versionId = versionId,
        )
        return getBucketObjectResultToKotlin(getBucketObjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketObject].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketObjectPlainArgs].
     * @return A collection of values returned by getBucketObject.
     */
    public suspend fun getBucketObject(argument: suspend GetBucketObjectPlainArgsBuilder.() -> Unit): GetBucketObjectResult {
        val builder = GetBucketObjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketObjectResultToKotlin(getBucketObjectPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** The `aws.s3.getBucketObjects` data source is DEPRECATED and will be removed in a future version! Use `aws.s3.getObjects` instead, where new features and fixes will be added.
     * > **NOTE on `max_keys`:** Retrieving very large numbers of keys can adversely affect this provider's performance.
     * The objects data source returns keys (i.e., file names) and other metadata about objects in an S3 bucket.
     * @param argument A collection of arguments for invoking getBucketObjects.
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(argument: GetBucketObjectsPlainArgs): GetBucketObjectsResult =
        getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())

    /**
     * @see [getBucketObjects].
     * @param bucket Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param delimiter Character used to group keys (Default: none)
     * @param encodingType Encodes keys using this method (Default: none; besides none, only "url" can be used)
     * @param fetchOwner Boolean specifying whether to populate the owner list (Default: false)
     * @param maxKeys Maximum object keys to return (Default: 1000)
     * @param prefix Limits results to object keys with this prefix (Default: none)
     * @param startAfter Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(
        bucket: String,
        delimiter: String? = null,
        encodingType: String? = null,
        fetchOwner: Boolean? = null,
        maxKeys: Int? = null,
        prefix: String? = null,
        startAfter: String? = null,
    ): GetBucketObjectsResult {
        val argument = GetBucketObjectsPlainArgs(
            bucket = bucket,
            delimiter = delimiter,
            encodingType = encodingType,
            fetchOwner = fetchOwner,
            maxKeys = maxKeys,
            prefix = prefix,
            startAfter = startAfter,
        )
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketObjects].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketObjectsPlainArgs].
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(argument: suspend GetBucketObjectsPlainArgsBuilder.() -> Unit): GetBucketObjectsResult {
        val builder = GetBucketObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * The bucket policy data source returns IAM policy of an S3 bucket.
     * ## Example Usage
     * The following example retrieves IAM policy of a specified S3 bucket.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.s3.getBucketPolicy({
     *     bucket: "example-bucket-name",
     * });
     * export const foo = example.then(example => example.policy);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.s3.get_bucket_policy(bucket="example-bucket-name")
     * pulumi.export("foo", example.policy)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.S3.GetBucketPolicy.Invoke(new()
     *     {
     *         Bucket = "example-bucket-name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["foo"] = example.Apply(getBucketPolicyResult => getBucketPolicyResult.Policy),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := s3.LookupBucketPolicy(ctx, &s3.LookupBucketPolicyArgs{
     * 			Bucket: "example-bucket-name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("foo", example.Policy)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getBucketPolicy(GetBucketPolicyArgs.builder()
     *             .bucket("example-bucket-name")
     *             .build());
     *         ctx.export("foo", example.applyValue(getBucketPolicyResult -> getBucketPolicyResult.policy()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:s3:getBucketPolicy
     *       Arguments:
     *         bucket: example-bucket-name
     * outputs:
     *   foo: ${example.policy}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBucketPolicy.
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(argument: GetBucketPolicyPlainArgs): GetBucketPolicyResult =
        getBucketPolicyResultToKotlin(getBucketPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBucketPolicy].
     * @param bucket Bucket name.
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(bucket: String): GetBucketPolicyResult {
        val argument = GetBucketPolicyPlainArgs(
            bucket = bucket,
        )
        return getBucketPolicyResultToKotlin(getBucketPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketPolicyPlainArgs].
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(argument: suspend GetBucketPolicyPlainArgsBuilder.() -> Unit): GetBucketPolicyResult {
        val builder = GetBucketPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketPolicyResultToKotlin(getBucketPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * The Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html)
     * for the effective account in which this provider is working.
     * > **NOTE:** To use this data source, you must have the `s3:ListAllMyBuckets` permission.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.s3.getCanonicalUserId({});
     * export const canonicalUserId = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.s3.get_canonical_user_id()
     * pulumi.export("canonicalUserId", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.S3.GetCanonicalUserId.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["canonicalUserId"] = current.Apply(getCanonicalUserIdResult => getCanonicalUserIdResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := s3.GetCanonicalUserId(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("canonicalUserId", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:s3:getCanonicalUserId
     *       Arguments: {}
     * outputs:
     *   canonicalUserId: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html)
     * for the effective account in which this provider is working.
     * > **NOTE:** To use this data source, you must have the `s3:ListAllMyBuckets` permission.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.s3.getCanonicalUserId({});
     * export const canonicalUserId = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.s3.get_canonical_user_id()
     * pulumi.export("canonicalUserId", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.S3.GetCanonicalUserId.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["canonicalUserId"] = current.Apply(getCanonicalUserIdResult => getCanonicalUserIdResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := s3.GetCanonicalUserId(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("canonicalUserId", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:s3:getCanonicalUserId
     *       Arguments: {}
     * outputs:
     *   canonicalUserId: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getCanonicalUserId.
     */
    public suspend fun getCanonicalUserId(): GetCanonicalUserIdResult =
        getCanonicalUserIdResultToKotlin(getCanonicalUserIdPlain().await())

    /**
     * Lists Amazon S3 Express directory buckets.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.s3.getDirectoryBuckets({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.s3.get_directory_buckets()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.S3.GetDirectoryBuckets.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := s3.GetDirectoryBuckets(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:s3:getDirectoryBuckets
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Lists Amazon S3 Express directory buckets.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.s3.getDirectoryBuckets({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.s3.get_directory_buckets()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.S3.GetDirectoryBuckets.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := s3.GetDirectoryBuckets(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:s3:getDirectoryBuckets
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getDirectoryBuckets.
     */
    public suspend fun getDirectoryBuckets(): GetDirectoryBucketsResult =
        getDirectoryBucketsResultToKotlin(getDirectoryBucketsPlain().await())

    /**
     * The S3 object data source allows access to the metadata and
     * _optionally_ (see below) content of an object stored inside S3 bucket.
     * > **Note:** The content of an object (`body` field) is available only for objects which have a human-readable `Content-Type`:
     * * `text/*`
     * * `application/json`
     * * `application/ld+json`
     * * `application/x-httpd-php`
     * * `application/xhtml+xml`
     * * `application/x-csh`
     * * `application/x-sh`
     * * `application/xml`
     * * `application/atom+xml`
     * * `application/x-sql`
     * This is to prevent printing unsafe characters and potentially downloading large amount of data which would be thrown away in favor of metadata.
     * ## Example Usage
     * The following example retrieves a text object (which must have a `Content-Type`
     * value starting with `text/`) and uses it as the `user_data` for an EC2 instance:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const bootstrapScript = aws.s3.getObject({
     *     bucket: "ourcorp-deploy-config",
     *     key: "ec2-bootstrap-script.sh",
     * });
     * const example = new aws.ec2.Instance("example", {
     *     instanceType: aws.ec2.InstanceType.T2_Micro,
     *     ami: "ami-2757f631",
     *     userData: bootstrapScript.then(bootstrapScript => bootstrapScript.body),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * bootstrap_script = aws.s3.get_object(bucket="ourcorp-deploy-config",
     *     key="ec2-bootstrap-script.sh")
     * example = aws.ec2.Instance("example",
     *     instance_type=aws.ec2.InstanceType.T2_MICRO,
     *     ami="ami-2757f631",
     *     user_data=bootstrap_script.body)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bootstrapScript = Aws.S3.GetObject.Invoke(new()
     *     {
     *         Bucket = "ourcorp-deploy-config",
     *         Key = "ec2-bootstrap-script.sh",
     *     });
     *     var example = new Aws.Ec2.Instance("example", new()
     *     {
     *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
     *         Ami = "ami-2757f631",
     *         UserData = bootstrapScript.Apply(getObjectResult => getObjectResult.Body),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		bootstrapScript, err := s3.GetObject(ctx, &s3.GetObjectArgs{
     * 			Bucket: "ourcorp-deploy-config",
     * 			Key:    "ec2-bootstrap-script.sh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "example", &ec2.InstanceArgs{
     * 			InstanceType: pulumi.String(ec2.InstanceType_T2_Micro),
     * 			Ami:          pulumi.String("ami-2757f631"),
     * 			UserData:     pulumi.String(bootstrapScript.Body),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetObjectArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bootstrapScript = S3Functions.getObject(GetObjectArgs.builder()
     *             .bucket("ourcorp-deploy-config")
     *             .key("ec2-bootstrap-script.sh")
     *             .build());
     *         var example = new Instance("example", InstanceArgs.builder()
     *             .instanceType("t2.micro")
     *             .ami("ami-2757f631")
     *             .userData(bootstrapScript.applyValue(getObjectResult -> getObjectResult.body()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:ec2:Instance
     *     properties:
     *       instanceType: t2.micro
     *       ami: ami-2757f631
     *       userData: ${bootstrapScript.body}
     * variables:
     *   bootstrapScript:
     *     fn::invoke:
     *       Function: aws:s3:getObject
     *       Arguments:
     *         bucket: ourcorp-deploy-config
     *         key: ec2-bootstrap-script.sh
     * ```
     * <!--End PulumiCodeChooser -->
     * The following, more-complex example retrieves only the metadata for a zip
     * file stored in S3, which is then used to pass the most recent `version_id`
     * to AWS Lambda for use as a function implementation. More information about
     * Lambda functions is available in the documentation for
     * `aws.lambda.Function`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const lambda = aws.s3.getObject({
     *     bucket: "ourcorp-lambda-functions",
     *     key: "hello-world.zip",
     * });
     * const testLambda = new aws.lambda.Function("test_lambda", {
     *     s3Bucket: lambda.then(lambda => lambda.bucket),
     *     s3Key: lambda.then(lambda => lambda.key),
     *     s3ObjectVersion: lambda.then(lambda => lambda.versionId),
     *     name: "lambda_function_name",
     *     role: iamForLambda.arn,
     *     handler: "exports.test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * lambda_ = aws.s3.get_object(bucket="ourcorp-lambda-functions",
     *     key="hello-world.zip")
     * test_lambda = aws.lambda_.Function("test_lambda",
     *     s3_bucket=lambda_.bucket,
     *     s3_key=lambda_.key,
     *     s3_object_version=lambda_.version_id,
     *     name="lambda_function_name",
     *     role=iam_for_lambda["arn"],
     *     handler="exports.test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var lambda = Aws.S3.GetObject.Invoke(new()
     *     {
     *         Bucket = "ourcorp-lambda-functions",
     *         Key = "hello-world.zip",
     *     });
     *     var testLambda = new Aws.Lambda.Function("test_lambda", new()
     *     {
     *         S3Bucket = lambda.Apply(getObjectResult => getObjectResult.Bucket),
     *         S3Key = lambda.Apply(getObjectResult => getObjectResult.Key),
     *         S3ObjectVersion = lambda.Apply(getObjectResult => getObjectResult.VersionId),
     *         Name = "lambda_function_name",
     *         Role = iamForLambda.Arn,
     *         Handler = "exports.test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		lambda, err := s3.GetObject(ctx, &s3.GetObjectArgs{
     * 			Bucket: "ourcorp-lambda-functions",
     * 			Key:    "hello-world.zip",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = lambda.NewFunction(ctx, "test_lambda", &lambda.FunctionArgs{
     * 			S3Bucket:        pulumi.String(lambda.Bucket),
     * 			S3Key:           pulumi.String(lambda.Key),
     * 			S3ObjectVersion: pulumi.String(lambda.VersionId),
     * 			Name:            pulumi.String("lambda_function_name"),
     * 			Role:            pulumi.Any(iamForLambda.Arn),
     * 			Handler:         pulumi.String("exports.test"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetObjectArgs;
     * import com.pulumi.aws.lambda.Function;
     * import com.pulumi.aws.lambda.FunctionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var lambda = S3Functions.getObject(GetObjectArgs.builder()
     *             .bucket("ourcorp-lambda-functions")
     *             .key("hello-world.zip")
     *             .build());
     *         var testLambda = new Function("testLambda", FunctionArgs.builder()
     *             .s3Bucket(lambda.applyValue(getObjectResult -> getObjectResult.bucket()))
     *             .s3Key(lambda.applyValue(getObjectResult -> getObjectResult.key()))
     *             .s3ObjectVersion(lambda.applyValue(getObjectResult -> getObjectResult.versionId()))
     *             .name("lambda_function_name")
     *             .role(iamForLambda.arn())
     *             .handler("exports.test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testLambda:
     *     type: aws:lambda:Function
     *     name: test_lambda
     *     properties:
     *       s3Bucket: ${lambda.bucket}
     *       s3Key: ${lambda.key}
     *       s3ObjectVersion: ${lambda.versionId}
     *       name: lambda_function_name
     *       role: ${iamForLambda.arn}
     *       handler: exports.test
     * variables:
     *   lambda:
     *     fn::invoke:
     *       Function: aws:s3:getObject
     *       Arguments:
     *         bucket: ourcorp-lambda-functions
     *         key: hello-world.zip
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getObject.
     * @return A collection of values returned by getObject.
     * */
     */
    public suspend fun getObject(argument: GetObjectPlainArgs): GetObjectResult =
        getObjectResultToKotlin(getObjectPlain(argument.toJava()).await())

    /**
     * @see [getObject].
     * @param bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param checksumMode To retrieve the object's checksum, this argument must be `ENABLED`. If you enable `checksum_mode` and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `ENABLED`
     * @param key Full path to the object inside the bucket
     * @param range
     * @param tags Map of tags assigned to the object.
     * @param versionId Specific version ID of the object returned (defaults to latest version)
     * @return A collection of values returned by getObject.
     */
    public suspend fun getObject(
        bucket: String,
        checksumMode: String? = null,
        key: String,
        range: String? = null,
        tags: Map<String, String>? = null,
        versionId: String? = null,
    ): GetObjectResult {
        val argument = GetObjectPlainArgs(
            bucket = bucket,
            checksumMode = checksumMode,
            key = key,
            range = range,
            tags = tags,
            versionId = versionId,
        )
        return getObjectResultToKotlin(getObjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getObject].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetObjectPlainArgs].
     * @return A collection of values returned by getObject.
     */
    public suspend fun getObject(argument: suspend GetObjectPlainArgsBuilder.() -> Unit): GetObjectResult {
        val builder = GetObjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObjectResultToKotlin(getObjectPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE on `max_keys`:** Retrieving very large numbers of keys can adversely affect the provider's performance.
     * The objects data source returns keys (i.e., file names) and other metadata about objects in an S3 bucket.
     * @param argument A collection of arguments for invoking getObjects.
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(argument: GetObjectsPlainArgs): GetObjectsResult =
        getObjectsResultToKotlin(getObjectsPlain(argument.toJava()).await())

    /**
     * @see [getObjects].
     * @param bucket Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param delimiter Character used to group keys (Default: none)
     * @param encodingType Encodes keys using this method (Default: none; besides none, only "url" can be used)
     * @param fetchOwner Boolean specifying whether to populate the owner list (Default: false)
     * @param maxKeys Maximum object keys to return (Default: 1000)
     * @param prefix Limits results to object keys with this prefix (Default: none)
     * @param requestPayer Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If included, the only valid value is `requester`.
     * @param startAfter Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(
        bucket: String,
        delimiter: String? = null,
        encodingType: String? = null,
        fetchOwner: Boolean? = null,
        maxKeys: Int? = null,
        prefix: String? = null,
        requestPayer: String? = null,
        startAfter: String? = null,
    ): GetObjectsResult {
        val argument = GetObjectsPlainArgs(
            bucket = bucket,
            delimiter = delimiter,
            encodingType = encodingType,
            fetchOwner = fetchOwner,
            maxKeys = maxKeys,
            prefix = prefix,
            requestPayer = requestPayer,
            startAfter = startAfter,
        )
        return getObjectsResultToKotlin(getObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getObjects].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetObjectsPlainArgs].
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(argument: suspend GetObjectsPlainArgsBuilder.() -> Unit): GetObjectsResult {
        val builder = GetObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObjectsResultToKotlin(getObjectsPlain(builtArgument.toJava()).await())
    }
}
