@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * See https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl
 */
public enum class CannedAcl(
    public val javaValue: com.pulumi.aws.s3.enums.CannedAcl,
) : ConvertibleToJava<com.pulumi.aws.s3.enums.CannedAcl> {
    Private(com.pulumi.aws.s3.enums.CannedAcl.Private),
    PublicRead(com.pulumi.aws.s3.enums.CannedAcl.PublicRead),
    PublicReadWrite(com.pulumi.aws.s3.enums.CannedAcl.PublicReadWrite),
    AwsExecRead(com.pulumi.aws.s3.enums.CannedAcl.AwsExecRead),
    AuthenticatedRead(com.pulumi.aws.s3.enums.CannedAcl.AuthenticatedRead),
    BucketOwnerRead(com.pulumi.aws.s3.enums.CannedAcl.BucketOwnerRead),
    BucketOwnerFullControl(com.pulumi.aws.s3.enums.CannedAcl.BucketOwnerFullControl),
    LogDeliveryWrite(com.pulumi.aws.s3.enums.CannedAcl.LogDeliveryWrite),
    ;

    override fun toJava(): com.pulumi.aws.s3.enums.CannedAcl = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.enums.CannedAcl): CannedAcl =
            CannedAcl.values().first { it.javaValue == javaType }
    }
}
