@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockPublicAcls Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
 * * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
 * * PUT Object calls fail if the request includes a public ACL.
 * * PUT Bucket calls fail if the request includes a public ACL.
 * @property blockPublicPolicy Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
 * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
 * @property ignorePublicAcls Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
 * * Ignore all public ACLs on buckets in this account and any objects that they contain.
 * @property restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
 * * Only the bucket owner and AWS Services can access buckets with public policies.
 */
public data class AccessPointPublicAccessBlockConfigurationArgs(
    public val blockPublicAcls: Output<Boolean>? = null,
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val ignorePublicAcls: Output<Boolean>? = null,
    public val restrictPublicBuckets: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs =
        com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs.builder()
            .blockPublicAcls(blockPublicAcls?.applyValue({ args0 -> args0 }))
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .ignorePublicAcls(ignorePublicAcls?.applyValue({ args0 -> args0 }))
            .restrictPublicBuckets(restrictPublicBuckets?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointPublicAccessBlockConfigurationArgs].
 */
@PulumiTagMarker
public class AccessPointPublicAccessBlockConfigurationArgsBuilder internal constructor() {
    private var blockPublicAcls: Output<Boolean>? = null

    private var blockPublicPolicy: Output<Boolean>? = null

    private var ignorePublicAcls: Output<Boolean>? = null

    private var restrictPublicBuckets: Output<Boolean>? = null

    /**
     * @param value Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
     * * PUT Object calls fail if the request includes a public ACL.
     * * PUT Bucket calls fail if the request includes a public ACL.
     */
    @JvmName("scxxrhnpbxwhfmli")
    public suspend fun blockPublicAcls(`value`: Output<Boolean>) {
        this.blockPublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("nrwdqmbwsrdyqwwq")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore all public ACLs on buckets in this account and any objects that they contain.
     */
    @JvmName("rjcapixtulnxlgeq")
    public suspend fun ignorePublicAcls(`value`: Output<Boolean>) {
        this.ignorePublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access buckets with public policies.
     */
    @JvmName("yrrnksoutemdymea")
    public suspend fun restrictPublicBuckets(`value`: Output<Boolean>) {
        this.restrictPublicBuckets = value
    }

    /**
     * @param value Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
     * * PUT Object calls fail if the request includes a public ACL.
     * * PUT Bucket calls fail if the request includes a public ACL.
     */
    @JvmName("psydthvjpxlcsoyd")
    public suspend fun blockPublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("estttpjrxtyjpdle")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore all public ACLs on buckets in this account and any objects that they contain.
     */
    @JvmName("gmrxmgeausrjfgaj")
    public suspend fun ignorePublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignorePublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access buckets with public policies.
     */
    @JvmName("tsgdpgogffoqenaq")
    public suspend fun restrictPublicBuckets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictPublicBuckets = mapped
    }

    internal fun build(): AccessPointPublicAccessBlockConfigurationArgs =
        AccessPointPublicAccessBlockConfigurationArgs(
            blockPublicAcls = blockPublicAcls,
            blockPublicPolicy = blockPublicPolicy,
            ignorePublicAcls = ignorePublicAcls,
            restrictPublicBuckets = restrictPublicBuckets,
        )
}
