@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object prefix for filtering.
 * @property tags Set of object tags for filtering.
 */
public data class AnalyticsConfigurationFilterArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs =
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AnalyticsConfigurationFilterArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object prefix for filtering.
     */
    @JvmName("jjoxfxihgqyucaqd")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Set of object tags for filtering.
     */
    @JvmName("pxoibyrrnbdauwak")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object prefix for filtering.
     */
    @JvmName("ualffkprerhfjaeb")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Set of object tags for filtering.
     */
    @JvmName("iwkmyygvluoghmdf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Set of object tags for filtering.
     */
    @JvmName("jxmhvqtnwswrefet")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AnalyticsConfigurationFilterArgs = AnalyticsConfigurationFilterArgs(
        prefix = prefix,
        tags = tags,
    )
}
