@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataExport Data export configuration (documented below).
 */
public data class AnalyticsConfigurationStorageClassAnalysisArgs(
    public val dataExport: Output<AnalyticsConfigurationStorageClassAnalysisDataExportArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs =
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs.builder()
            .dataExport(dataExport.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsConfigurationStorageClassAnalysisArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationStorageClassAnalysisArgsBuilder internal constructor() {
    private var dataExport: Output<AnalyticsConfigurationStorageClassAnalysisDataExportArgs>? = null

    /**
     * @param value Data export configuration (documented below).
     */
    @JvmName("hgessvlqvyoxtswu")
    public suspend fun dataExport(`value`: Output<AnalyticsConfigurationStorageClassAnalysisDataExportArgs>) {
        this.dataExport = value
    }

    /**
     * @param value Data export configuration (documented below).
     */
    @JvmName("gpxqibmwseymeweb")
    public suspend fun dataExport(`value`: AnalyticsConfigurationStorageClassAnalysisDataExportArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataExport = mapped
    }

    /**
     * @param argument Data export configuration (documented below).
     */
    @JvmName("gejvhshtcducayxd")
    public suspend fun dataExport(argument: suspend AnalyticsConfigurationStorageClassAnalysisDataExportArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConfigurationStorageClassAnalysisDataExportArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataExport = mapped
    }

    internal fun build(): AnalyticsConfigurationStorageClassAnalysisArgs =
        AnalyticsConfigurationStorageClassAnalysisArgs(
            dataExport = dataExport ?: throw PulumiNullFieldException("dataExport"),
        )
}
