@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destination Specifies the destination for the exported analytics data (documented below).
 * @property outputSchemaVersion Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
 */
public data class AnalyticsConfigurationStorageClassAnalysisDataExportArgs(
    public val destination: Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs>,
    public val outputSchemaVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs =
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputSchemaVersion(outputSchemaVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConfigurationStorageClassAnalysisDataExportArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationStorageClassAnalysisDataExportArgsBuilder internal constructor() {
    private var destination:
        Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs>? = null

    private var outputSchemaVersion: Output<String>? = null

    /**
     * @param value Specifies the destination for the exported analytics data (documented below).
     */
    @JvmName("bwmrjedxixjynobm")
    public suspend fun destination(`value`: Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
     */
    @JvmName("mpvhajvbjcwetgjs")
    public suspend fun outputSchemaVersion(`value`: Output<String>) {
        this.outputSchemaVersion = value
    }

    /**
     * @param value Specifies the destination for the exported analytics data (documented below).
     */
    @JvmName("ahgmvmuppphrkfea")
    public suspend fun destination(`value`: AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Specifies the destination for the exported analytics data (documented below).
     */
    @JvmName("jhathewqpoxgrced")
    public suspend fun destination(argument: suspend AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
     */
    @JvmName("wdhvjafddscbyers")
    public suspend fun outputSchemaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputSchemaVersion = mapped
    }

    internal fun build(): AnalyticsConfigurationStorageClassAnalysisDataExportArgs =
        AnalyticsConfigurationStorageClassAnalysisDataExportArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
            outputSchemaVersion = outputSchemaVersion,
        )
}
