@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketDestination Analytics data export currently only supports an S3 bucket destination (documented below).
 */
public data class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs(
    public val s3BucketDestination: Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs =
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs.builder()
            .s3BucketDestination(
                s3BucketDestination.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgsBuilder internal constructor() {
    private var s3BucketDestination:
        Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs>? =
        null

    /**
     * @param value Analytics data export currently only supports an S3 bucket destination (documented below).
     */
    @JvmName("slxpscotgnmvxejc")
    public suspend fun s3BucketDestination(`value`: Output<AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs>) {
        this.s3BucketDestination = value
    }

    /**
     * @param value Analytics data export currently only supports an S3 bucket destination (documented below).
     */
    @JvmName("putxybfpawdldarc")
    public suspend fun s3BucketDestination(`value`: AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketDestination = mapped
    }

    /**
     * @param argument Analytics data export currently only supports an S3 bucket destination (documented below).
     */
    @JvmName("makjhgvkliaornav")
    public suspend fun s3BucketDestination(argument: suspend AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3BucketDestination = mapped
    }

    internal fun build(): AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs =
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs(
            s3BucketDestination = s3BucketDestination ?: throw PulumiNullFieldException("s3BucketDestination"),
        )
}
