@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property grants Set of `grant` configuration blocks. See below.
 * @property owner Configuration block for the bucket owner's display name and ID. See below.
 */
public data class BucketAclV2AccessControlPolicyArgs(
    public val grants: Output<List<BucketAclV2AccessControlPolicyGrantArgs>>? = null,
    public val owner: Output<BucketAclV2AccessControlPolicyOwnerArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs =
        com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs.builder()
            .grants(grants?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owner(owner.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketAclV2AccessControlPolicyArgs].
 */
@PulumiTagMarker
public class BucketAclV2AccessControlPolicyArgsBuilder internal constructor() {
    private var grants: Output<List<BucketAclV2AccessControlPolicyGrantArgs>>? = null

    private var owner: Output<BucketAclV2AccessControlPolicyOwnerArgs>? = null

    /**
     * @param value Set of `grant` configuration blocks. See below.
     */
    @JvmName("tdadfenpkxlghkru")
    public suspend fun grants(`value`: Output<List<BucketAclV2AccessControlPolicyGrantArgs>>) {
        this.grants = value
    }

    @JvmName("cgsbriikmdldtqlq")
    public suspend fun grants(vararg values: Output<BucketAclV2AccessControlPolicyGrantArgs>) {
        this.grants = Output.all(values.asList())
    }

    /**
     * @param values Set of `grant` configuration blocks. See below.
     */
    @JvmName("mqkbldwuubbubebg")
    public suspend fun grants(values: List<Output<BucketAclV2AccessControlPolicyGrantArgs>>) {
        this.grants = Output.all(values)
    }

    /**
     * @param value Configuration block for the bucket owner's display name and ID. See below.
     */
    @JvmName("xqcwhsesihsnhbdd")
    public suspend fun owner(`value`: Output<BucketAclV2AccessControlPolicyOwnerArgs>) {
        this.owner = value
    }

    /**
     * @param value Set of `grant` configuration blocks. See below.
     */
    @JvmName("qnvilarnrmjvhunj")
    public suspend fun grants(`value`: List<BucketAclV2AccessControlPolicyGrantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param argument Set of `grant` configuration blocks. See below.
     */
    @JvmName("oipdkfwjjcbxdbkw")
    public suspend fun grants(argument: List<suspend BucketAclV2AccessControlPolicyGrantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketAclV2AccessControlPolicyGrantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument Set of `grant` configuration blocks. See below.
     */
    @JvmName("iutvscvvofpkhrlr")
    public suspend fun grants(vararg argument: suspend BucketAclV2AccessControlPolicyGrantArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketAclV2AccessControlPolicyGrantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument Set of `grant` configuration blocks. See below.
     */
    @JvmName("rylrmppahnrjtuih")
    public suspend fun grants(argument: suspend BucketAclV2AccessControlPolicyGrantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketAclV2AccessControlPolicyGrantArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param values Set of `grant` configuration blocks. See below.
     */
    @JvmName("stlhkiujjjmyqkgu")
    public suspend fun grants(vararg values: BucketAclV2AccessControlPolicyGrantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param value Configuration block for the bucket owner's display name and ID. See below.
     */
    @JvmName("jxndqxscffxtmexu")
    public suspend fun owner(`value`: BucketAclV2AccessControlPolicyOwnerArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param argument Configuration block for the bucket owner's display name and ID. See below.
     */
    @JvmName("vtrkqpmcwtohmlns")
    public suspend fun owner(argument: suspend BucketAclV2AccessControlPolicyOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = BucketAclV2AccessControlPolicyOwnerArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.owner = mapped
    }

    internal fun build(): BucketAclV2AccessControlPolicyArgs = BucketAclV2AccessControlPolicyArgs(
        grants = grants,
        owner = owner ?: throw PulumiNullFieldException("owner"),
    )
}
