@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantGranteeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property displayName Display name of the owner.
 * @property emailAddress Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
 * @property id Canonical user ID of the grantee.
 * @property type Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
 * @property uri URI of the grantee group.
 */
public data class BucketAclV2AccessControlPolicyGrantGranteeArgs(
    public val displayName: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val id: Output<String>? = null,
    public val type: Output<String>,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantGranteeArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantGranteeArgs =
        com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAclV2AccessControlPolicyGrantGranteeArgs].
 */
@PulumiTagMarker
public class BucketAclV2AccessControlPolicyGrantGranteeArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var id: Output<String>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Display name of the owner.
     */
    @JvmName("wyqnxqfesexhkvbg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
     */
    @JvmName("chblrrrajcqnrgyc")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value Canonical user ID of the grantee.
     */
    @JvmName("wkmohxdiumibrosb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
     */
    @JvmName("qjrhgomhmeiurwbp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value URI of the grantee group.
     */
    @JvmName("eyiretnbrwtshspm")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Display name of the owner.
     */
    @JvmName("dapkkqfmnliclwlg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
     */
    @JvmName("ngiafexvfmlsxvyl")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value Canonical user ID of the grantee.
     */
    @JvmName("ycfmslwmmmiklxhe")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
     */
    @JvmName("endcgcpthodckpfj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value URI of the grantee group.
     */
    @JvmName("ruvoyjawxqcxqbyn")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): BucketAclV2AccessControlPolicyGrantGranteeArgs =
        BucketAclV2AccessControlPolicyGrantGranteeArgs(
            displayName = displayName,
            emailAddress = emailAddress,
            id = id,
            type = type ?: throw PulumiNullFieldException("type"),
            uri = uri,
        )
}
