@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property displayName Display name of the owner.
 * @property id ID of the owner.
 */
public data class BucketAclV2AccessControlPolicyOwnerArgs(
    public val displayName: Output<String>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs =
        com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAclV2AccessControlPolicyOwnerArgs].
 */
@PulumiTagMarker
public class BucketAclV2AccessControlPolicyOwnerArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    /**
     * @param value Display name of the owner.
     */
    @JvmName("vlstvmygrcymfhee")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value ID of the owner.
     */
    @JvmName("rmmwdekijqonubpl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Display name of the owner.
     */
    @JvmName("yedgdwpjeyovuuja")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value ID of the owner.
     */
    @JvmName("rcsehctyegaasdrc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): BucketAclV2AccessControlPolicyOwnerArgs =
        BucketAclV2AccessControlPolicyOwnerArgs(
            displayName = displayName,
            id = id ?: throw PulumiNullFieldException("id"),
        )
}
