@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property abortIncompleteMultipartUpload Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
 * @property expiration Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
 * @property filter Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
 * @property id Unique identifier for the rule. The value cannot be longer than 255 characters.
 * @property noncurrentVersionExpiration Configuration block that specifies when noncurrent object versions expire. See below.
 * @property noncurrentVersionTransitions Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
 * @property prefix **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
 * @property status Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
 * @property transitions Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
 */
public data class BucketLifecycleConfigurationV2RuleArgs(
    public val abortIncompleteMultipartUpload: Output<BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs>? = null,
    public val expiration: Output<BucketLifecycleConfigurationV2RuleExpirationArgs>? = null,
    public val filter: Output<BucketLifecycleConfigurationV2RuleFilterArgs>? = null,
    public val id: Output<String>,
    public val noncurrentVersionExpiration: Output<BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs>? = null,
    public val noncurrentVersionTransitions: Output<List<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>>? = null,
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    public val prefix: Output<String>? = null,
    public val status: Output<String>,
    public val transitions: Output<List<BucketLifecycleConfigurationV2RuleTransitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs.builder()
            .abortIncompleteMultipartUpload(
                abortIncompleteMultipartUpload?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .expiration(expiration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id.applyValue({ args0 -> args0 }))
            .noncurrentVersionExpiration(
                noncurrentVersionExpiration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .noncurrentVersionTransitions(
                noncurrentVersionTransitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 }))
            .transitions(
                transitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleArgsBuilder internal constructor() {
    private var abortIncompleteMultipartUpload:
        Output<BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs>? = null

    private var expiration: Output<BucketLifecycleConfigurationV2RuleExpirationArgs>? = null

    private var filter: Output<BucketLifecycleConfigurationV2RuleFilterArgs>? = null

    private var id: Output<String>? = null

    private var noncurrentVersionExpiration:
        Output<BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs>? = null

    private var noncurrentVersionTransitions:
        Output<List<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>>? = null

    private var prefix: Output<String>? = null

    private var status: Output<String>? = null

    private var transitions: Output<List<BucketLifecycleConfigurationV2RuleTransitionArgs>>? = null

    /**
     * @param value Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
     */
    @JvmName("buvcqokwlhgdyrfh")
    public suspend fun abortIncompleteMultipartUpload(`value`: Output<BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs>) {
        this.abortIncompleteMultipartUpload = value
    }

    /**
     * @param value Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
     */
    @JvmName("ouvsdvsxguyxqrio")
    public suspend fun expiration(`value`: Output<BucketLifecycleConfigurationV2RuleExpirationArgs>) {
        this.expiration = value
    }

    /**
     * @param value Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("hxdiklloyfdcnxsv")
    public suspend fun filter(`value`: Output<BucketLifecycleConfigurationV2RuleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    @JvmName("cfelkqfrbkodkvpe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Configuration block that specifies when noncurrent object versions expire. See below.
     */
    @JvmName("elftcuynhduppssx")
    public suspend fun noncurrentVersionExpiration(`value`: Output<BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs>) {
        this.noncurrentVersionExpiration = value
    }

    /**
     * @param value Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("qtkgjagqyfgfrlop")
    public suspend fun noncurrentVersionTransitions(`value`: Output<List<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = value
    }

    @JvmName("pmfkvbwyfthcfldx")
    public suspend fun noncurrentVersionTransitions(vararg values: Output<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>) {
        this.noncurrentVersionTransitions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("lwlgvayqnrlggogw")
    public suspend fun noncurrentVersionTransitions(values: List<Output<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = Output.all(values)
    }

    /**
     * @param value **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
     */
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    @JvmName("xtknluoysvmepylx")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
     */
    @JvmName("mxotpcvxasrtiekh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("bsracpilnchmaxfe")
    public suspend fun transitions(`value`: Output<List<BucketLifecycleConfigurationV2RuleTransitionArgs>>) {
        this.transitions = value
    }

    @JvmName("flwyymwjsqlsguep")
    public suspend fun transitions(vararg values: Output<BucketLifecycleConfigurationV2RuleTransitionArgs>) {
        this.transitions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("imlpvqmsmauiovrr")
    public suspend fun transitions(values: List<Output<BucketLifecycleConfigurationV2RuleTransitionArgs>>) {
        this.transitions = Output.all(values)
    }

    /**
     * @param value Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
     */
    @JvmName("irthjqtbodlqqpty")
    public suspend fun abortIncompleteMultipartUpload(`value`: BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortIncompleteMultipartUpload = mapped
    }

    /**
     * @param argument Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
     */
    @JvmName("cwwvamaadnioucvd")
    public suspend fun abortIncompleteMultipartUpload(argument: suspend BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.abortIncompleteMultipartUpload = mapped
    }

    /**
     * @param value Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
     */
    @JvmName("flxtfmrvdfbbjikk")
    public suspend fun expiration(`value`: BucketLifecycleConfigurationV2RuleExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param argument Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
     */
    @JvmName("gpgjtsvcbbivhhiw")
    public suspend fun expiration(argument: suspend BucketLifecycleConfigurationV2RuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationV2RuleExpirationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.expiration = mapped
    }

    /**
     * @param value Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("kbtbujfonnxjfcbq")
    public suspend fun filter(`value`: BucketLifecycleConfigurationV2RuleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("kbipfjnmmowctdel")
    public suspend fun filter(argument: suspend BucketLifecycleConfigurationV2RuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationV2RuleFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    @JvmName("lswirkxoiqgttapp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Configuration block that specifies when noncurrent object versions expire. See below.
     */
    @JvmName("eqokyvfgmcntrqes")
    public suspend fun noncurrentVersionExpiration(`value`: BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionExpiration = mapped
    }

    /**
     * @param argument Configuration block that specifies when noncurrent object versions expire. See below.
     */
    @JvmName("pfrmwgwxslngelav")
    public suspend fun noncurrentVersionExpiration(argument: suspend BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpiration = mapped
    }

    /**
     * @param value Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("yxyfcqpbohyvcahm")
    public suspend fun noncurrentVersionTransitions(`value`: List<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("mthgiwrvgooqxhsg")
    public suspend fun noncurrentVersionTransitions(argument: List<suspend BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("qhmboernpmkwdeqa")
    public suspend fun noncurrentVersionTransitions(vararg argument: suspend BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("dqdwwknrbtlgxtcv")
    public suspend fun noncurrentVersionTransitions(argument: suspend BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param values Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
     */
    @JvmName("qxwbmkwnmurjbbmb")
    public suspend fun noncurrentVersionTransitions(vararg values: BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param value **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
     */
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    @JvmName("cpvsxvoyvfpvxrtb")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
     */
    @JvmName("foauyrxpmseqnjce")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("ovcletrwdvkskbap")
    public suspend fun transitions(`value`: List<BucketLifecycleConfigurationV2RuleTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("ekrtxpfwpoqqrgwb")
    public suspend fun transitions(argument: List<suspend BucketLifecycleConfigurationV2RuleTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationV2RuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("fimnwqtkfcagcoad")
    public suspend fun transitions(vararg argument: suspend BucketLifecycleConfigurationV2RuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationV2RuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("ibxuunwjnyavngws")
    public suspend fun transitions(argument: suspend BucketLifecycleConfigurationV2RuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleConfigurationV2RuleTransitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param values Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
     */
    @JvmName("wvjkusugnshhypva")
    public suspend fun transitions(vararg values: BucketLifecycleConfigurationV2RuleTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleArgs =
        BucketLifecycleConfigurationV2RuleArgs(
            abortIncompleteMultipartUpload = abortIncompleteMultipartUpload,
            expiration = expiration,
            filter = filter,
            id = id ?: throw PulumiNullFieldException("id"),
            noncurrentVersionExpiration = noncurrentVersionExpiration,
            noncurrentVersionTransitions = noncurrentVersionTransitions,
            prefix = prefix,
            status = status ?: throw PulumiNullFieldException("status"),
            transitions = transitions,
        )
}
