@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property date Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
 * @property days Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
 * @property expiredObjectDeleteMarker Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
 */
public data class BucketLifecycleConfigurationV2RuleExpirationArgs(
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val expiredObjectDeleteMarker: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleExpirationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleExpirationArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleExpirationArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .expiredObjectDeleteMarker(expiredObjectDeleteMarker?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleExpirationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleExpirationArgsBuilder internal constructor() {
    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var expiredObjectDeleteMarker: Output<Boolean>? = null

    /**
     * @param value Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
     */
    @JvmName("uqvvtvurlloriwcg")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
     */
    @JvmName("esjswattwyqgflum")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
     */
    @JvmName("yalpdeheqlhcabxt")
    public suspend fun expiredObjectDeleteMarker(`value`: Output<Boolean>) {
        this.expiredObjectDeleteMarker = value
    }

    /**
     * @param value Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
     */
    @JvmName("afolcplepsgxyunt")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
     */
    @JvmName("xmwiaddiujaqafro")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
     */
    @JvmName("gwrutouylnodcbcm")
    public suspend fun expiredObjectDeleteMarker(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiredObjectDeleteMarker = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleExpirationArgs =
        BucketLifecycleConfigurationV2RuleExpirationArgs(
            date = date,
            days = days,
            expiredObjectDeleteMarker = expiredObjectDeleteMarker,
        )
}
