@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property objectSizeGreaterThan Minimum object size to which the rule applies. Value must be at least `0` if specified.
 * @property objectSizeLessThan Maximum object size to which the rule applies. Value must be at least `1` if specified.
 * @property prefix Prefix identifying one or more objects to which the rule applies.
 * @property tags Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
 */
public data class BucketLifecycleConfigurationV2RuleFilterAndArgs(
    public val objectSizeGreaterThan: Output<Int>? = null,
    public val objectSizeLessThan: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs.builder()
            .objectSizeGreaterThan(objectSizeGreaterThan?.applyValue({ args0 -> args0 }))
            .objectSizeLessThan(objectSizeLessThan?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleFilterAndArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleFilterAndArgsBuilder internal constructor() {
    private var objectSizeGreaterThan: Output<Int>? = null

    private var objectSizeLessThan: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Minimum object size to which the rule applies. Value must be at least `0` if specified.
     */
    @JvmName("diandawvvvpregia")
    public suspend fun objectSizeGreaterThan(`value`: Output<Int>) {
        this.objectSizeGreaterThan = value
    }

    /**
     * @param value Maximum object size to which the rule applies. Value must be at least `1` if specified.
     */
    @JvmName("ctnufktpakfohola")
    public suspend fun objectSizeLessThan(`value`: Output<Int>) {
        this.objectSizeLessThan = value
    }

    /**
     * @param value Prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("yxvxdtmjoicaowgp")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("vrqmttidacoyafsi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Minimum object size to which the rule applies. Value must be at least `0` if specified.
     */
    @JvmName("qhfsgofjeqjpecwj")
    public suspend fun objectSizeGreaterThan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeGreaterThan = mapped
    }

    /**
     * @param value Maximum object size to which the rule applies. Value must be at least `1` if specified.
     */
    @JvmName("kdfugkmfslcddubh")
    public suspend fun objectSizeLessThan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeLessThan = mapped
    }

    /**
     * @param value Prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("inndaoqjxvinpciu")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("gylwuidljmigtwaw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("vkljvpjjjgaywyfu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleFilterAndArgs =
        BucketLifecycleConfigurationV2RuleFilterAndArgs(
            objectSizeGreaterThan = objectSizeGreaterThan,
            objectSizeLessThan = objectSizeLessThan,
            prefix = prefix,
            tags = tags,
        )
}
