@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property and Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
 * @property objectSizeGreaterThan Minimum object size (in bytes) to which the rule applies.
 * @property objectSizeLessThan Maximum object size (in bytes) to which the rule applies.
 * @property prefix Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
 * @property tag Configuration block for specifying a tag key and value. See below.
 */
public data class BucketLifecycleConfigurationV2RuleFilterArgs(
    public val and: Output<BucketLifecycleConfigurationV2RuleFilterAndArgs>? = null,
    public val objectSizeGreaterThan: Output<String>? = null,
    public val objectSizeLessThan: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val tag: Output<BucketLifecycleConfigurationV2RuleFilterTagArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs.builder()
            .and(and?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .objectSizeGreaterThan(objectSizeGreaterThan?.applyValue({ args0 -> args0 }))
            .objectSizeLessThan(objectSizeLessThan?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleFilterArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleFilterArgsBuilder internal constructor() {
    private var and: Output<BucketLifecycleConfigurationV2RuleFilterAndArgs>? = null

    private var objectSizeGreaterThan: Output<String>? = null

    private var objectSizeLessThan: Output<String>? = null

    private var prefix: Output<String>? = null

    private var tag: Output<BucketLifecycleConfigurationV2RuleFilterTagArgs>? = null

    /**
     * @param value Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
     */
    @JvmName("mawixpajcnbhrcdr")
    public suspend fun and(`value`: Output<BucketLifecycleConfigurationV2RuleFilterAndArgs>) {
        this.and = value
    }

    /**
     * @param value Minimum object size (in bytes) to which the rule applies.
     */
    @JvmName("itdassbhdfdrkenc")
    public suspend fun objectSizeGreaterThan(`value`: Output<String>) {
        this.objectSizeGreaterThan = value
    }

    /**
     * @param value Maximum object size (in bytes) to which the rule applies.
     */
    @JvmName("hkrvcjktlxovlnth")
    public suspend fun objectSizeLessThan(`value`: Output<String>) {
        this.objectSizeLessThan = value
    }

    /**
     * @param value Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
     */
    @JvmName("vrcrvgxqeqwypdpq")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("lqylwthkqvkyqvio")
    public suspend fun tag(`value`: Output<BucketLifecycleConfigurationV2RuleFilterTagArgs>) {
        this.tag = value
    }

    /**
     * @param value Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
     */
    @JvmName("rrftliotkuiertxy")
    public suspend fun and(`value`: BucketLifecycleConfigurationV2RuleFilterAndArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param argument Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
     */
    @JvmName("bjmhqjvjrkpndqse")
    public suspend fun and(argument: suspend BucketLifecycleConfigurationV2RuleFilterAndArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationV2RuleFilterAndArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param value Minimum object size (in bytes) to which the rule applies.
     */
    @JvmName("gbojswhhnqfkfhjo")
    public suspend fun objectSizeGreaterThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeGreaterThan = mapped
    }

    /**
     * @param value Maximum object size (in bytes) to which the rule applies.
     */
    @JvmName("vrqigtmqymduqbeh")
    public suspend fun objectSizeLessThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeLessThan = mapped
    }

    /**
     * @param value Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
     */
    @JvmName("icemifgiljvcifvy")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("nymkylohlwaflrmi")
    public suspend fun tag(`value`: BucketLifecycleConfigurationV2RuleFilterTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param argument Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("spnttewvmgsultsb")
    public suspend fun tag(argument: suspend BucketLifecycleConfigurationV2RuleFilterTagArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationV2RuleFilterTagArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tag = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleFilterArgs =
        BucketLifecycleConfigurationV2RuleFilterArgs(
            and = and,
            objectSizeGreaterThan = objectSizeGreaterThan,
            objectSizeLessThan = objectSizeLessThan,
            prefix = prefix,
            tag = tag,
        )
}
