@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Name of the object key.
 * @property value Value of the tag.
 */
public data class BucketLifecycleConfigurationV2RuleFilterTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterTagArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterTagArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleFilterTagArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleFilterTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the object key.
     */
    @JvmName("rjfkrknridwlywly")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value of the tag.
     */
    @JvmName("hkdinhqhjrnesxma")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the object key.
     */
    @JvmName("kppugrisvdpxnqxl")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value of the tag.
     */
    @JvmName("xktddxiknfetyboc")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleFilterTagArgs =
        BucketLifecycleConfigurationV2RuleFilterTagArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
