@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property date Date objects are transitioned to the specified storage class. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
 * @property days Number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer. If both `days` and `date` are not specified, defaults to `0`. Valid values depend on `storage_class`, see [Transition objects using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-transition-general-considerations.html) for more details.
 * @property storageClass Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
 */
public data class BucketLifecycleConfigurationV2RuleTransitionArgs(
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val storageClass: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleTransitionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleTransitionArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleTransitionArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleTransitionArgsBuilder internal constructor() {
    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Date objects are transitioned to the specified storage class. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
     */
    @JvmName("xfshlycvvpwtgocp")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer. If both `days` and `date` are not specified, defaults to `0`. Valid values depend on `storage_class`, see [Transition objects using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-transition-general-considerations.html) for more details.
     */
    @JvmName("lstoudveuhqssoas")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
     */
    @JvmName("kcnmfxooeoguyvfj")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Date objects are transitioned to the specified storage class. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
     */
    @JvmName("wpqpbgouptyiuwrr")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer. If both `days` and `date` are not specified, defaults to `0`. Valid values depend on `storage_class`, see [Transition objects using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-transition-general-considerations.html) for more details.
     */
    @JvmName("rrfiqkotrvhuevlw")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
     */
    @JvmName("yfmktcwstponpqvh")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleTransitionArgs =
        BucketLifecycleConfigurationV2RuleTransitionArgs(
            date = date,
            days = days,
            storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
        )
}
