@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property storageClass Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
 */
public data class BucketLifecycleRuleNoncurrentVersionTransitionArgs(
    public val days: Output<Int>? = null,
    public val storageClass: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs = com.pulumi.aws.s3.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder()
        .days(days?.applyValue({ args0 -> args0 }))
        .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleNoncurrentVersionTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("foggnhtbsppnwjgh")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("ayaklmsufmbkotqp")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("kggofwumexcqsnnv")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("gjnttlculjgyswli")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleRuleNoncurrentVersionTransitionArgs =
        BucketLifecycleRuleNoncurrentVersionTransitionArgs(
            days = days,
            storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
        )
}
