@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetBucket Name of the bucket that will receive the log objects.
 * @property targetPrefix To specify a key prefix for log objects.
 */
public data class BucketLoggingArgs(
    public val targetBucket: Output<String>,
    public val targetPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLoggingArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLoggingArgs =
        com.pulumi.aws.s3.inputs.BucketLoggingArgs.builder()
            .targetBucket(targetBucket.applyValue({ args0 -> args0 }))
            .targetPrefix(targetPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingArgs].
 */
@PulumiTagMarker
public class BucketLoggingArgsBuilder internal constructor() {
    private var targetBucket: Output<String>? = null

    private var targetPrefix: Output<String>? = null

    /**
     * @param value Name of the bucket that will receive the log objects.
     */
    @JvmName("jqaohvvprnwmnwha")
    public suspend fun targetBucket(`value`: Output<String>) {
        this.targetBucket = value
    }

    /**
     * @param value To specify a key prefix for log objects.
     */
    @JvmName("ggblikwtkmoaykyq")
    public suspend fun targetPrefix(`value`: Output<String>) {
        this.targetPrefix = value
    }

    /**
     * @param value Name of the bucket that will receive the log objects.
     */
    @JvmName("gcnguhiuijsgimhi")
    public suspend fun targetBucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetBucket = mapped
    }

    /**
     * @param value To specify a key prefix for log objects.
     */
    @JvmName("jlorffprbdpqkvjb")
    public suspend fun targetPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPrefix = mapped
    }

    internal fun build(): BucketLoggingArgs = BucketLoggingArgs(
        targetBucket = targetBucket ?: throw PulumiNullFieldException("targetBucket"),
        targetPrefix = targetPrefix,
    )
}
