@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property partitionedPrefix Partitioned S3 key for log objects. See below.
 * @property simplePrefix Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
 */
public data class BucketLoggingV2TargetObjectKeyFormatArgs(
    public val partitionedPrefix: Output<BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs>? =
        null,
    public val simplePrefix: Output<BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatArgs =
        com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatArgs.builder()
            .partitionedPrefix(partitionedPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .simplePrefix(simplePrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketLoggingV2TargetObjectKeyFormatArgs].
 */
@PulumiTagMarker
public class BucketLoggingV2TargetObjectKeyFormatArgsBuilder internal constructor() {
    private var partitionedPrefix: Output<BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs>? =
        null

    private var simplePrefix: Output<BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgs>? = null

    /**
     * @param value Partitioned S3 key for log objects. See below.
     */
    @JvmName("sfoeaerldcoknugl")
    public suspend fun partitionedPrefix(`value`: Output<BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs>) {
        this.partitionedPrefix = value
    }

    /**
     * @param value Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
     */
    @JvmName("sckrvwkroopgnqoj")
    public suspend fun simplePrefix(`value`: Output<BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgs>) {
        this.simplePrefix = value
    }

    /**
     * @param value Partitioned S3 key for log objects. See below.
     */
    @JvmName("elsoslsdgiccgquu")
    public suspend fun partitionedPrefix(`value`: BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionedPrefix = mapped
    }

    /**
     * @param argument Partitioned S3 key for log objects. See below.
     */
    @JvmName("yknuwmqkbkacrdvr")
    public suspend fun partitionedPrefix(argument: suspend BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.partitionedPrefix = mapped
    }

    /**
     * @param value Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
     */
    @JvmName("ndlrgwunewiaduvr")
    public suspend fun simplePrefix(`value`: BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simplePrefix = mapped
    }

    /**
     * @param argument Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
     */
    @JvmName("bhwxqlbixrglrlsm")
    public suspend fun simplePrefix(argument: suspend BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.simplePrefix = mapped
    }

    internal fun build(): BucketLoggingV2TargetObjectKeyFormatArgs =
        BucketLoggingV2TargetObjectKeyFormatArgs(
            partitionedPrefix = partitionedPrefix,
            simplePrefix = simplePrefix,
        )
}
