@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
 * @property filterPrefix Object key name prefix.
 * @property filterSuffix Object key name suffix.
 * @property id Unique identifier for each of the notification configurations.
 * @property lambdaFunctionArn Lambda function ARN.
 */
public data class BucketNotificationLambdaFunctionArgs(
    public val events: Output<List<String>>,
    public val filterPrefix: Output<String>? = null,
    public val filterSuffix: Output<String>? = null,
    public val id: Output<String>? = null,
    public val lambdaFunctionArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs =
        com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs.builder()
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filterPrefix(filterPrefix?.applyValue({ args0 -> args0 }))
            .filterSuffix(filterSuffix?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .lambdaFunctionArn(lambdaFunctionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketNotificationLambdaFunctionArgs].
 */
@PulumiTagMarker
public class BucketNotificationLambdaFunctionArgsBuilder internal constructor() {
    private var events: Output<List<String>>? = null

    private var filterPrefix: Output<String>? = null

    private var filterSuffix: Output<String>? = null

    private var id: Output<String>? = null

    private var lambdaFunctionArn: Output<String>? = null

    /**
     * @param value [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("vbognwllylxauxkf")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("xxqajcfwlshdxeod")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("blsophydtwoqedgd")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("cqencjfsitrgxyfw")
    public suspend fun filterPrefix(`value`: Output<String>) {
        this.filterPrefix = value
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("apoaodibxqenvofm")
    public suspend fun filterSuffix(`value`: Output<String>) {
        this.filterSuffix = value
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("fjccphmkrknwscfd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Lambda function ARN.
     */
    @JvmName("rrgboixctgbeqwrw")
    public suspend fun lambdaFunctionArn(`value`: Output<String>) {
        this.lambdaFunctionArn = value
    }

    /**
     * @param value [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("tpodjrmamwmnufkt")
    public suspend fun events(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("syqmllhlxpsmajud")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("mlgreygrqnrubupw")
    public suspend fun filterPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPrefix = mapped
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("wlrplngcfcvdhivy")
    public suspend fun filterSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterSuffix = mapped
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("smopnxtwgsqrftje")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Lambda function ARN.
     */
    @JvmName("wndkephvncuobpbq")
    public suspend fun lambdaFunctionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionArn = mapped
    }

    internal fun build(): BucketNotificationLambdaFunctionArgs = BucketNotificationLambdaFunctionArgs(
        events = events ?: throw PulumiNullFieldException("events"),
        filterPrefix = filterPrefix,
        filterSuffix = filterSuffix,
        id = id,
        lambdaFunctionArn = lambdaFunctionArn,
    )
}
