@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
 * @property filterPrefix Object key name prefix.
 * @property filterSuffix Object key name suffix.
 * @property id Unique identifier for each of the notification configurations.
 * @property queueArn SQS queue ARN.
 */
public data class BucketNotificationQueueArgs(
    public val events: Output<List<String>>,
    public val filterPrefix: Output<String>? = null,
    public val filterSuffix: Output<String>? = null,
    public val id: Output<String>? = null,
    public val queueArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs =
        com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs.builder()
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filterPrefix(filterPrefix?.applyValue({ args0 -> args0 }))
            .filterSuffix(filterSuffix?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .queueArn(queueArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketNotificationQueueArgs].
 */
@PulumiTagMarker
public class BucketNotificationQueueArgsBuilder internal constructor() {
    private var events: Output<List<String>>? = null

    private var filterPrefix: Output<String>? = null

    private var filterSuffix: Output<String>? = null

    private var id: Output<String>? = null

    private var queueArn: Output<String>? = null

    /**
     * @param value Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("qubqdpypxxhfoiyk")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("imcmwxehahlsdylb")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("mvpddmxagrkwlmna")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("ueogobefqxtcwqpp")
    public suspend fun filterPrefix(`value`: Output<String>) {
        this.filterPrefix = value
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("vfyywiystsilgwgc")
    public suspend fun filterSuffix(`value`: Output<String>) {
        this.filterSuffix = value
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("ubcgrcwvyjythkqe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value SQS queue ARN.
     */
    @JvmName("bighjupbjpwhpewi")
    public suspend fun queueArn(`value`: Output<String>) {
        this.queueArn = value
    }

    /**
     * @param value Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("anamggckjuyliolh")
    public suspend fun events(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("hstkgjcafxkhnghl")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("omjwjukhrjggpmyq")
    public suspend fun filterPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPrefix = mapped
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("fmxhrcpwvlmvvtqv")
    public suspend fun filterSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterSuffix = mapped
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("tpnouuevdrfxslwc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value SQS queue ARN.
     */
    @JvmName("vssrimlycuierwee")
    public suspend fun queueArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueArn = mapped
    }

    internal fun build(): BucketNotificationQueueArgs = BucketNotificationQueueArgs(
        events = events ?: throw PulumiNullFieldException("events"),
        filterPrefix = filterPrefix,
        filterSuffix = filterSuffix,
        id = id,
        queueArn = queueArn ?: throw PulumiNullFieldException("queueArn"),
    )
}
