@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
 * @property rule Object Lock rule in place for this bucket (documented below).
 */
public data class BucketObjectLockConfigurationArgs(
    public val objectLockEnabled: Output<String>,
    public val rule: Output<BucketObjectLockConfigurationRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs.builder()
            .objectLockEnabled(objectLockEnabled.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketObjectLockConfigurationArgs].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationArgsBuilder internal constructor() {
    private var objectLockEnabled: Output<String>? = null

    private var rule: Output<BucketObjectLockConfigurationRuleArgs>? = null

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @JvmName("ycrpmiyjxdhkuwyk")
    public suspend fun objectLockEnabled(`value`: Output<String>) {
        this.objectLockEnabled = value
    }

    /**
     * @param value Object Lock rule in place for this bucket (documented below).
     */
    @JvmName("vvbvajthgcrttxdn")
    public suspend fun rule(`value`: Output<BucketObjectLockConfigurationRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @JvmName("elpcxpvpwwgugeuv")
    public suspend fun objectLockEnabled(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectLockEnabled = mapped
    }

    /**
     * @param value Object Lock rule in place for this bucket (documented below).
     */
    @JvmName("gxggmdcvhvpwhdth")
    public suspend fun rule(`value`: BucketObjectLockConfigurationRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument Object Lock rule in place for this bucket (documented below).
     */
    @JvmName("cmhbbqnymqelhrjl")
    public suspend fun rule(argument: suspend BucketObjectLockConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    internal fun build(): BucketObjectLockConfigurationArgs = BucketObjectLockConfigurationArgs(
        objectLockEnabled = objectLockEnabled ?: throw PulumiNullFieldException("objectLockEnabled"),
        rule = rule,
    )
}
