@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultRetention Default retention period that you want to apply to new objects placed in this bucket (documented below).
 */
public data class BucketObjectLockConfigurationRuleArgs(
    public val defaultRetention: Output<BucketObjectLockConfigurationRuleDefaultRetentionArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleArgs.builder()
            .defaultRetention(
                defaultRetention.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketObjectLockConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationRuleArgsBuilder internal constructor() {
    private var defaultRetention: Output<BucketObjectLockConfigurationRuleDefaultRetentionArgs>? =
        null

    /**
     * @param value Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("ocjxwwoobbcajofd")
    public suspend fun defaultRetention(`value`: Output<BucketObjectLockConfigurationRuleDefaultRetentionArgs>) {
        this.defaultRetention = value
    }

    /**
     * @param value Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("anaqtpgmjlggjinj")
    public suspend fun defaultRetention(`value`: BucketObjectLockConfigurationRuleDefaultRetentionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRetention = mapped
    }

    /**
     * @param argument Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("vgjjgbmsluhuagld")
    public suspend fun defaultRetention(argument: suspend BucketObjectLockConfigurationRuleDefaultRetentionArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationRuleDefaultRetentionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultRetention = mapped
    }

    internal fun build(): BucketObjectLockConfigurationRuleArgs =
        BucketObjectLockConfigurationRuleArgs(
            defaultRetention = defaultRetention ?: throw PulumiNullFieldException("defaultRetention"),
        )
}
