@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleDefaultRetentionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Number of days that you want to specify for the default retention period.
 * @property mode Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
 * @property years Number of years that you want to specify for the default retention period.
 */
public data class BucketObjectLockConfigurationRuleDefaultRetentionArgs(
    public val days: Output<Int>? = null,
    public val mode: Output<String>,
    public val years: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleDefaultRetentionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleDefaultRetentionArgs =
        com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationRuleDefaultRetentionArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .years(years?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketObjectLockConfigurationRuleDefaultRetentionArgs].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationRuleDefaultRetentionArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var mode: Output<String>? = null

    private var years: Output<Int>? = null

    /**
     * @param value Number of days that you want to specify for the default retention period.
     */
    @JvmName("pjnquxmhoirvpfni")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    @JvmName("kfxmciompcldxnph")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Number of years that you want to specify for the default retention period.
     */
    @JvmName("cqtpjucibtreexjh")
    public suspend fun years(`value`: Output<Int>) {
        this.years = value
    }

    /**
     * @param value Number of days that you want to specify for the default retention period.
     */
    @JvmName("yfdpghoywylqshae")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    @JvmName("ycpsprtffcprtwpq")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Number of years that you want to specify for the default retention period.
     */
    @JvmName("hsrswdrmuteadmnj")
    public suspend fun years(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.years = mapped
    }

    internal fun build(): BucketObjectLockConfigurationRuleDefaultRetentionArgs =
        BucketObjectLockConfigurationRuleDefaultRetentionArgs(
            days = days,
            mode = mode ?: throw PulumiNullFieldException("mode"),
            years = years,
        )
}
