@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectv2OverrideProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultTags Override the provider `default_tags` configuration block.
 */
public data class BucketObjectv2OverrideProviderArgs(
    public val defaultTags: Output<BucketObjectv2OverrideProviderDefaultTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectv2OverrideProviderArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectv2OverrideProviderArgs =
        com.pulumi.aws.s3.inputs.BucketObjectv2OverrideProviderArgs.builder()
            .defaultTags(defaultTags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketObjectv2OverrideProviderArgs].
 */
@PulumiTagMarker
public class BucketObjectv2OverrideProviderArgsBuilder internal constructor() {
    private var defaultTags: Output<BucketObjectv2OverrideProviderDefaultTagsArgs>? = null

    /**
     * @param value Override the provider `default_tags` configuration block.
     */
    @JvmName("dludswfvlnnxgdmi")
    public suspend fun defaultTags(`value`: Output<BucketObjectv2OverrideProviderDefaultTagsArgs>) {
        this.defaultTags = value
    }

    /**
     * @param value Override the provider `default_tags` configuration block.
     */
    @JvmName("uwabrordtqbmyfcg")
    public suspend fun defaultTags(`value`: BucketObjectv2OverrideProviderDefaultTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTags = mapped
    }

    /**
     * @param argument Override the provider `default_tags` configuration block.
     */
    @JvmName("oklsowvkickhjbwr")
    public suspend fun defaultTags(argument: suspend BucketObjectv2OverrideProviderDefaultTagsArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectv2OverrideProviderDefaultTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultTags = mapped
    }

    internal fun build(): BucketObjectv2OverrideProviderArgs = BucketObjectv2OverrideProviderArgs(
        defaultTags = defaultTags,
    )
}
