@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property objectOwnership Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
 * * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
 * * `ObjectWriter` - Uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
 * * `BucketOwnerEnforced` - Bucket owner automatically owns and has full control over every object in the bucket. ACLs no longer affect permissions to data in the S3 bucket.
 */
public data class BucketOwnershipControlsRuleArgs(
    public val objectOwnership: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs =
        com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs.builder()
            .objectOwnership(objectOwnership.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketOwnershipControlsRuleArgs].
 */
@PulumiTagMarker
public class BucketOwnershipControlsRuleArgsBuilder internal constructor() {
    private var objectOwnership: Output<String>? = null

    /**
     * @param value Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
     * * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
     * * `ObjectWriter` - Uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
     * * `BucketOwnerEnforced` - Bucket owner automatically owns and has full control over every object in the bucket. ACLs no longer affect permissions to data in the S3 bucket.
     */
    @JvmName("oyvlojgonvdyoyyv")
    public suspend fun objectOwnership(`value`: Output<String>) {
        this.objectOwnership = value
    }

    /**
     * @param value Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
     * * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
     * * `ObjectWriter` - Uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
     * * `BucketOwnerEnforced` - Bucket owner automatically owns and has full control over every object in the bucket. ACLs no longer affect permissions to data in the S3 bucket.
     */
    @JvmName("uhtjkneypwqcjbjs")
    public suspend fun objectOwnership(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectOwnership = mapped
    }

    internal fun build(): BucketOwnershipControlsRuleArgs = BucketOwnershipControlsRuleArgs(
        objectOwnership = objectOwnership ?: throw PulumiNullFieldException("objectOwnership"),
    )
}
