@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property deleteMarkerReplication Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
 * @property destination Specifies the destination for the rule. See below.
 * @property existingObjectReplication Replicate existing objects in the source bucket according to the rule configurations. See below.
 * @property filter Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
 * @property priority Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriteria Specifies special object selection criteria. See below.
 * @property status Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
 */
public data class BucketReplicationConfigRuleArgs(
    public val deleteMarkerReplication: Output<BucketReplicationConfigRuleDeleteMarkerReplicationArgs>? = null,
    public val destination: Output<BucketReplicationConfigRuleDestinationArgs>,
    public val existingObjectReplication: Output<BucketReplicationConfigRuleExistingObjectReplicationArgs>? = null,
    public val filter: Output<BucketReplicationConfigRuleFilterArgs>? = null,
    public val id: Output<String>? = null,
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    public val prefix: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val sourceSelectionCriteria: Output<BucketReplicationConfigRuleSourceSelectionCriteriaArgs>? = null,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs.builder()
            .deleteMarkerReplication(
                deleteMarkerReplication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .existingObjectReplication(
                existingObjectReplication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .sourceSelectionCriteria(
                sourceSelectionCriteria?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleArgsBuilder internal constructor() {
    private var deleteMarkerReplication:
        Output<BucketReplicationConfigRuleDeleteMarkerReplicationArgs>? = null

    private var destination: Output<BucketReplicationConfigRuleDestinationArgs>? = null

    private var existingObjectReplication:
        Output<BucketReplicationConfigRuleExistingObjectReplicationArgs>? = null

    private var filter: Output<BucketReplicationConfigRuleFilterArgs>? = null

    private var id: Output<String>? = null

    private var prefix: Output<String>? = null

    private var priority: Output<Int>? = null

    private var sourceSelectionCriteria:
        Output<BucketReplicationConfigRuleSourceSelectionCriteriaArgs>? = null

    private var status: Output<String>? = null

    /**
     * @param value Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
     */
    @JvmName("anrylqvefntkhiek")
    public suspend fun deleteMarkerReplication(`value`: Output<BucketReplicationConfigRuleDeleteMarkerReplicationArgs>) {
        this.deleteMarkerReplication = value
    }

    /**
     * @param value Specifies the destination for the rule. See below.
     */
    @JvmName("yvvriwlbivixwbpe")
    public suspend fun destination(`value`: Output<BucketReplicationConfigRuleDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Replicate existing objects in the source bucket according to the rule configurations. See below.
     */
    @JvmName("cqlurqrgccvinwhx")
    public suspend fun existingObjectReplication(`value`: Output<BucketReplicationConfigRuleExistingObjectReplicationArgs>) {
        this.existingObjectReplication = value
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("riggtrfonochouxu")
    public suspend fun filter(`value`: Output<BucketReplicationConfigRuleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("lnqjeljmjursucaf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
     */
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    @JvmName("sqwxoqyqoowdaaso")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("wphwxayikxonfwxx")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Specifies special object selection criteria. See below.
     */
    @JvmName("sjduukriniepjbdy")
    public suspend fun sourceSelectionCriteria(`value`: Output<BucketReplicationConfigRuleSourceSelectionCriteriaArgs>) {
        this.sourceSelectionCriteria = value
    }

    /**
     * @param value Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
     */
    @JvmName("adkinnyaxijkogdk")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
     */
    @JvmName("irdaxlpwcytwkbgx")
    public suspend fun deleteMarkerReplication(`value`: BucketReplicationConfigRuleDeleteMarkerReplicationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteMarkerReplication = mapped
    }

    /**
     * @param argument Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
     */
    @JvmName("elcvgcquesutllyt")
    public suspend fun deleteMarkerReplication(argument: suspend BucketReplicationConfigRuleDeleteMarkerReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleDeleteMarkerReplicationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deleteMarkerReplication = mapped
    }

    /**
     * @param value Specifies the destination for the rule. See below.
     */
    @JvmName("ylgdulquwsqmpfif")
    public suspend fun destination(`value`: BucketReplicationConfigRuleDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Specifies the destination for the rule. See below.
     */
    @JvmName("niiuknqwikfgrryk")
    public suspend fun destination(argument: suspend BucketReplicationConfigRuleDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Replicate existing objects in the source bucket according to the rule configurations. See below.
     */
    @JvmName("jlnyqgoxxkijnsfi")
    public suspend fun existingObjectReplication(`value`: BucketReplicationConfigRuleExistingObjectReplicationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.existingObjectReplication = mapped
    }

    /**
     * @param argument Replicate existing objects in the source bucket according to the rule configurations. See below.
     */
    @JvmName("rquaknbtidpiccve")
    public suspend fun existingObjectReplication(argument: suspend BucketReplicationConfigRuleExistingObjectReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleExistingObjectReplicationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.existingObjectReplication = mapped
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("dulyqkmpsbkpfhkx")
    public suspend fun filter(`value`: BucketReplicationConfigRuleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
     */
    @JvmName("ynuspsengumvgwlj")
    public suspend fun filter(argument: suspend BucketReplicationConfigRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("yafbxfdkwhqwxnvl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
     */
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    @JvmName("xtxmieftlhlvyvtl")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("iegposdibyisccxx")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies special object selection criteria. See below.
     */
    @JvmName("mtmftlivpmmlvuay")
    public suspend fun sourceSelectionCriteria(`value`: BucketReplicationConfigRuleSourceSelectionCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param argument Specifies special object selection criteria. See below.
     */
    @JvmName("yidggplqcewioasj")
    public suspend fun sourceSelectionCriteria(argument: suspend BucketReplicationConfigRuleSourceSelectionCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleSourceSelectionCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param value Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
     */
    @JvmName("pfbkwkcrbjsnafgx")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketReplicationConfigRuleArgs = BucketReplicationConfigRuleArgs(
        deleteMarkerReplication = deleteMarkerReplication,
        destination = destination ?: throw PulumiNullFieldException("destination"),
        existingObjectReplication = existingObjectReplication,
        filter = filter,
        id = id,
        prefix = prefix,
        priority = priority,
        sourceSelectionCriteria = sourceSelectionCriteria,
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
