@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDeleteMarkerReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Whether delete markers should be replicated. Either `"Enabled"` or `"Disabled"`.
 */
public data class BucketReplicationConfigRuleDeleteMarkerReplicationArgs(
    public val status: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDeleteMarkerReplicationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDeleteMarkerReplicationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDeleteMarkerReplicationArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDeleteMarkerReplicationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDeleteMarkerReplicationArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Whether delete markers should be replicated. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("uibpkaspufoqhmin")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether delete markers should be replicated. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("kdsoeoaraqjdgvbw")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDeleteMarkerReplicationArgs =
        BucketReplicationConfigRuleDeleteMarkerReplicationArgs(
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
