@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationAccessControlTranslationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property owner Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
 */
public data class BucketReplicationConfigRuleDestinationAccessControlTranslationArgs(
    public val owner: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationAccessControlTranslationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationAccessControlTranslationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationAccessControlTranslationArgs.builder()
            .owner(owner.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDestinationAccessControlTranslationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDestinationAccessControlTranslationArgsBuilder internal constructor() {
    private var owner: Output<String>? = null

    /**
     * @param value Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
     */
    @JvmName("uqcfueyjmlfbdkht")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
     */
    @JvmName("rgluyvbvjprayepd")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDestinationAccessControlTranslationArgs =
        BucketReplicationConfigRuleDestinationAccessControlTranslationArgs(
            owner = owner ?: throw PulumiNullFieldException("owner"),
        )
}
