@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property replicaModifications Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
 * @property sseKmsEncryptedObjects Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
 */
public data class BucketReplicationConfigRuleSourceSelectionCriteriaArgs(
    public val replicaModifications: Output<BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs>? = null,
    public val sseKmsEncryptedObjects: Output<BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaArgs.builder()
            .replicaModifications(
                replicaModifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sseKmsEncryptedObjects(
                sseKmsEncryptedObjects?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketReplicationConfigRuleSourceSelectionCriteriaArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleSourceSelectionCriteriaArgsBuilder internal constructor() {
    private var replicaModifications:
        Output<BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs>? = null

    private var sseKmsEncryptedObjects:
        Output<BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? = null

    /**
     * @param value Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
     */
    @JvmName("gmghinswsvngwfxk")
    public suspend fun replicaModifications(`value`: Output<BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs>) {
        this.replicaModifications = value
    }

    /**
     * @param value Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
     */
    @JvmName("xbddbajthxoawoji")
    public suspend fun sseKmsEncryptedObjects(`value`: Output<BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>) {
        this.sseKmsEncryptedObjects = value
    }

    /**
     * @param value Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
     */
    @JvmName("ypkdifjwrurphghp")
    public suspend fun replicaModifications(`value`: BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaModifications = mapped
    }

    /**
     * @param argument Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
     */
    @JvmName("lcdatnqenjgtdipo")
    public suspend fun replicaModifications(argument: suspend BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.replicaModifications = mapped
    }

    /**
     * @param value Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
     */
    @JvmName("ycghdwwajlndaxey")
    public suspend fun sseKmsEncryptedObjects(`value`: BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
     */
    @JvmName("eefgcytqehqwcytr")
    public suspend fun sseKmsEncryptedObjects(argument: suspend BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    internal fun build(): BucketReplicationConfigRuleSourceSelectionCriteriaArgs =
        BucketReplicationConfigRuleSourceSelectionCriteriaArgs(
            replicaModifications = replicaModifications,
            sseKmsEncryptedObjects = sseKmsEncryptedObjects,
        )
}
